/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 *  $Id: DeleteDomainCommand.java,v 1.4 2006/02/02 00:21:45 pa100654 Exp $
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.DomainConfig;

/**
 * Deletes a domain of the Application server
 */
public class DeleteDomainCommand extends BaseLifeCycleCommand 
{


    /** Creates new DeleteDomainCommand */
    public DeleteDomainCommand() 
    {
    }

    /**
     * Validates the Options for correctness
     * @return boolean returns true if validation is succesful else false
     */
    public boolean validateOptions() throws CommandValidationException 
    {
        return super.validateOptions();
    }
    
    /**
     * Executes the command
     * @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException 
    {
        validateOptions();
	
	String domainName = null;
        try
        {            
	    domainName = (String)operands.firstElement();
            DomainConfig domainConfig = getDomainConfig(domainName);
            DomainsManager manager = getFeatureFactory().getDomainsManager();
            manager.deleteDomain(domainConfig);
            deleteLoginInfo();
        }
        catch (Exception e)
        {
	    CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
	    throw new CommandException(getLocalizedString("CouldNotDeleteDomain",
							  new Object[] {domainName}));
        }

	CLILogger.getInstance().printDetailMessage(getLocalizedString("DomainDeleted",
                                             new Object[] {domainName}));
    }


    /**
     * This method will delete the entry in the .asadminpass file if exists
     */
    private void deleteLoginInfo() throws CommandValidationException 
    {
        return;
    }
    
}
