/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.ext.logging.LogAnalyzer;
import java.util.Map;
import java.text.DateFormat;
import java.util.Vector;

public class DisplayErrorStatisticsCommand extends BaseLoggingCommand 
{
    protected void handleReturnValue(Object retVal) 
    {
        final Map[] errorInfo = (Map[])retVal;
        
        if (errorInfo.length > 0)
        {
            String sTitle = String.format("%1$-39s %2$-9s %3$-8s",
                                          getLocalizedString("Timestamp"),
                                          getLocalizedString("Severity"),
                                          getLocalizedString("Warning"));
            
            CLILogger.getInstance().printDetailMessage(sTitle);
            
            CLILogger.getInstance().printDetailMessage("---------------------------------------------------------");
        }
        for (Map errorRecord : errorInfo)
        {
            final Long timeStamp = (Long) errorRecord.get(LogAnalyzer.TIMESTAMP_KEY);
            final java.util.Date date = new java.util.Date(timeStamp);

            final Integer severeCount = 
                    (Integer) errorRecord.get(LogAnalyzer.SEVERE_COUNT_KEY);
            final Integer warningCount = 
                    (Integer) errorRecord.get(LogAnalyzer.WARNING_COUNT_KEY);

            final String sDate = (getBooleanOption(TERSE))?timeStamp.toString():
                                 timeStamp.toString()+
                                 "("+DateFormat.getDateTimeInstance().format(date)+")";

            final String sErrorRecord = String.format("%1$-43s %2$-8s %3$-8s", sDate, 
                                                    (severeCount.intValue()<0)?"NA":severeCount, 
                                                    (warningCount.intValue()<0)?"NA":warningCount);
            CLILogger.getInstance().printMessage(sErrorRecord);
        }
        if (errorInfo.length > 0)
        {
            CLILogger.getInstance().printDetailMessage("---------------------------------------------------------");
        }
    }
}
