/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIAdminCommands;

/**
 *  Will show information about a component, shared library or service assembly.
 *  @version  $Revision: 1.2 $
 */
public class JBIShowCommands extends JBICommand
{
    private static final String SHOW_BINDING_COMPONENT  = "show-jbi-binding-component";
    private static final String SHOW_SERVICE_ENGINE     = "show-jbi-service-engine";
    private static final String SHOW_SHARED_LIBRARY     = "show-jbi-shared-library";
    private static final String SHOW_SERVICE_ASSEMBLY   = "show-jbi-service-assembly";

    /**
     *  A method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        String result = "";
        try {

            // Perform the pre run initialization
            if (preRunInit())
            {
                // Retrieve the options used for this command
                String  targetName     = getOption(TARGET_OPTION);

                // Retrieve the operand "name"
                String  componentName = (String) getOperands().get(0);
                
                // Using the command name, we'll determine how to process the command
                if (name.equals(SHOW_BINDING_COMPONENT)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).showBindingComponent(
                        componentName,
                        "",
                        "",
                        "",
                        targetName);
                    processJBIAdminShowComponentResult(result,componentName);
                }

                else if (name.equals(SHOW_SERVICE_ENGINE)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).showServiceEngine(
                        componentName,
                        "",
                        "",
                        "",
                        targetName);
                    processJBIAdminShowComponentResult(result,componentName);
                }

                else if (name.equals(SHOW_SHARED_LIBRARY)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).showSharedLibrary(
                        componentName,
                        "",
                        targetName);
                    processJBIAdminShowLibraryResult(result,componentName);
                }

                else if (name.equals(SHOW_SERVICE_ASSEMBLY)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).showServiceAssembly(
                        componentName,
                        "",
                        "",
                        targetName);
                    processJBIAdminShowAssemblyResult(result,componentName);
                }
            }
        }

        catch (Exception e) {
            processTaskException(e);
        }
    }
}
