/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIAdminCommands;

/**
 *  Will start the JBI component on the specified target.
 *  @version  $Revision: 1.3 $
 */
public class JBIUninstallCommands extends JBICommand
{
    private static final String UNINSTALL_COMPONENT        = "uninstall-jbi-component";
    private static final String UNINSTALL_SHARED_LIBRARY   = "uninstall-jbi-shared-library";
    private static final String UNDEPLOY_SERVICE_ASSEMBLY  = "undeploy-jbi-service-assembly";

    /**
     *  A method that Executes the command
     *  @throws CommandException
     */

    public void runCommand() throws CommandException, CommandValidationException
    {
        String result = "";
        String successKey = "";
        try {

            // Perform the pre run initialization
            if (preRunInit())
            {
                // Retrieve the options
                String  targetName  = getOption(TARGET_OPTION);
                boolean force       = getBooleanOption(FORCE_OPTION);
                boolean keepArchive = getBooleanOption(KEEP_ARCHIVE_OPTION);

                // Retrieve the operand
                String  componentName = (String) getOperands().get(0);

                // Using the command name, we'll determine how to process the command
                if (name.equals(UNINSTALL_COMPONENT)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).uninstallComponent(
                            componentName,
                            force,
                            keepArchive,
                            targetName);
                    successKey = "JBISuccessUninstallComponent";
                }

                else if (name.equals(UNINSTALL_SHARED_LIBRARY)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).uninstallSharedLibrary(
                            componentName,
                            force,
                            keepArchive,
                            targetName);
                    successKey = "JBISuccessUninstallSharedLibrary";
                }

                else if (name.equals(UNDEPLOY_SERVICE_ASSEMBLY)) {
                    result = ((JBIAdminCommands) mJbiAdminCommands).undeployServiceAssembly(
                            componentName,
                            force,
                            keepArchive,
                            targetName);
                    successKey = "JBISuccessUndeployServiceAssembly";
                }

                // Display the success message
                CLILogger.getInstance().printDetailMessage (
                        getLocalizedString (successKey,new Object[] {componentName}));
            }
        }

        catch (Exception e) {
            processTaskException(e);
        }
    }
}

