/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import java.util.Properties;
import java.util.Enumeration;

public class ListManagementRulesCommand extends GenericCommand
{
    private static final String DEFAULT_TARGET = "server";
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                              getUser(), getPassword());
        String config = resolveTargetToConfig(mbsc);
        String objectName = "com.sun.appserv:type=management-rules,config=" +
                            config + ",category=config";
        CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
        //use http connector
        final String operationName = getOperationName();

        try
        { 
            Object returnValue = mbsc.invoke(new ObjectName(objectName), 
                                            operationName, null, null);
            handleReturnValue(returnValue);
	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }        
    
    }


    /**
     *  resolves the target to config name
     *  @throws CommandException
     */
    private String resolveTargetToConfig(MBeanServerConnection mbsc) throws CommandException
    {
        String objectName = "com.sun.appserv:type=configs,category=config";
        String target = (getOperands().size() == 1) ? 
                    (String) getOperands().get(0) : DEFAULT_TARGET;
        final Object[] params = new Object[] {target};
        final String operationName = "getConfigNameForTarget";
        final String[] types = new String[] {"java.lang.String"};

        try
        { 
            String returnValue =  (String) mbsc.invoke(
                                            new ObjectName(objectName), 
                                            operationName, params, types);
            return (returnValue);
        }
        catch(Exception e)
        {
            throw new CommandException(e.getLocalizedMessage());
        }        
    
    }
}
