/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import java.util.Iterator;
import java.util.Vector;
import com.sun.enterprise.cli.framework.*;


/**
 *  This class is the unset command.
 *  It will unset the given environment variable in multimode.
 */
public class UnsetCommand extends S1ASCommand 
{

    private final static String ENVIRONMENT_PREFIX = "AS_ADMIN_";
    private final static String ENVIRONMENT_DELIMITER = "=";

    private CommandEnvironment commandEnvironment = CommandEnvironment.getInstance();

    /** Creates new UnsetCommand */
    public UnsetCommand() 
    {
    }

    /**
     * Validates the Options for correctness
     * @return boolean returns true if validation is succesful else false
     */
    public boolean validateOptions() throws CommandValidationException 
    {
        return super.validateOptions();
    }
    
    /**
     * Executes the command
     * @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException 
    {
        validateOptions();
        
        for (int ii = 0; ii < operands.size(); ii++)
        {
	    updateEnvironment((String)operands.elementAt(ii));
        }
    }

    
    /**
     * this method check for prefix AS_ADMIN
     * returns the name without the prefix AS_ADMIN
     */
    private String checkForPrefix(String name) throws CommandException
    {
	String envName = null;
	//check for prefix AS_ADMIN
        if (name.regionMatches(true, 0, ENVIRONMENT_PREFIX, 0, 
                               ENVIRONMENT_PREFIX.length())) 
        {
	    //extract AS_ADMIN from sOperandName
            envName =  name.substring(ENVIRONMENT_PREFIX.length());
        }
	else 
        {
	    throw new CommandException(getLocalizedString("CouldNotUnsetVariable",
							  new Object[] {name}));
	}
	return envName.toLowerCase();
    }

    
    /**
     *  this method updates the variables by removing them from the
     *  command environment (local and global).
     *  @param nameStr - the name of the environment to remove
     *  @throws CommandException if environment could not be removed.
     */
    private void updateEnvironment(String nameStr)
	throws CommandException
    {
	final String envName = checkForPrefix(nameStr);
	if (envName.equals("*"))
	{
            // Remove both the local and global environment variables
            removeAllEnvironments();
	}
	else
	{
            if (MultiProcessCommand.removeLocalEnvironment(envName) != null)
            {
                // Also remove the global environment if exists
                commandEnvironment.removeEnvironment(envName);
            }
            else if (commandEnvironment.removeEnvironment(envName) == null)
            {
		throw new CommandException(getLocalizedString("UnableToRemoveEnv",
					   new Object[] {nameStr}));
            }
	}
    }


    /**
     *  this method is called when AS_ADMIN_* is encountered.
     *  The wildcard means to remove all variables set in the environment.
     */
    private void removeAllEnvironments()
    {
        // remove the Local environments
        MultiProcessCommand.removeAllEnvironments();
        
        final java.util.HashMap envMap = new
           java.util.HashMap(commandEnvironment.getEnvironments());
        final java.util.Iterator envIter = envMap.keySet().iterator();

        while (envIter.hasNext())
        {
            final String envName = (String)envIter.next();
            if (commandEnvironment.removeEnvironment(envName) == null)
                CLILogger.getInstance().printWarning(getLocalizedString(
                                                    "UnableToRemoveEnv",
                                                    new Object[] {envName}));
        }
     }
}
