/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.StringTokenizer;
import java.util.Map;
import java.util.Timer;
import java.util.List;
import java.util.Vector;
import java.io.File;

abstract class BeanMonitorTask extends MonitorTask
{
    String appName        = null;
    String ejbName        = null;
    String beanName = null;    

    public BeanMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                              final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);
    }

    
    /**
     *  Returns all the possible ejbmodules in all the application.
     *  The return format is <app-name>:<ejbmodule>:<bean>
     */
    String[] possibleAppModuleFilters()
    {
        final Map<String,ApplicationMonitor> appModuleMap = srm.getApplicationMonitorMap();

        List<String> possibleFilters = new Vector<String>();
        if (appModuleMap != null && appModuleMap.size() > 0)
        {
                //search through all application and check for the ejbs
            final String[] appModules = MapUtil.getKeyStrings(appModuleMap);
            for (String appModule : appModules)
            {
                ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(appModule);
                    //search for the ejb in the appmodule
                final  Map<String,EJBModuleMonitor> innerEjbModuleMap = am.getEJBModuleMonitorMap();
                possibleFilters = getBeansInEjbModule(appModule, innerEjbModuleMap);
            }
        }
        return (String[])possibleFilters.toArray(new String[0]);
    }
    
    
    /**
     *  Returns all the possible servlets in all the ejbmodules.
     *  The return format is <ejbmodule>:<servlet>
     */
    String[] possibleEjbModuleFilters()
    {
        final Map<String,EJBModuleMonitor> ejbModuleMap = srm.getEJBModuleMonitorMap();
        List<String> possibleFilters = getBeansInEjbModule(null, ejbModuleMap);
        return (String[])possibleFilters.toArray(new String[0]);
    }


    /**
     *  If filter option is not specified, then this method will
     *  get the default filter value.
     */
    void getDefaultFilter() throws MonitorTaskException
    {
        String[] appModuleFilters = possibleAppModuleFilters();
        String[] ejbModuleFilters = possibleEjbModuleFilters();        
            
        if (ejbModuleFilters.length < 1 && appModuleFilters.length < 1)
        {
            throw new MonitorTaskException("No value to monitor.");
        }
        else if (ejbModuleFilters.length == 1 && appModuleFilters.length < 1)
        {
            final String temp = ejbModuleFilters[0];
            final StringTokenizer st = new StringTokenizer(temp, ":");
            ejbName = st.nextToken();
            beanName = st.nextToken();
        }
        else if (ejbModuleFilters.length < 1 && appModuleFilters.length == 1)
        {
            final String temp = appModuleFilters[0];
            final StringTokenizer st = new StringTokenizer(temp, ":");
            appName = st.nextToken();
            ejbName = st.nextToken();
            beanName = st.nextToken();            
        }
        else
        {
            final String msg = getAvailableFilterMessage(appModuleFilters, ejbModuleFilters);
            throw new MonitorTaskException(msg);
        }
    }


    private String getAvailableFilterMessage(final String[] appModuleFilters,
                                             final String[] ejbModuleFilters)
    {
        StringBuffer sb = new StringBuffer();
        sb.append("There are more than one monitoring elements. ");
        sb.append("Please consider using the filter option.\n");
        if (ejbModuleFilters.length > 0)
        {
            sb.append("The following are available elements to monitor in ejbmodule <ejbmodule>:<bean> \n");
            for (String ejbmodule : ejbModuleFilters)
            {
                sb.append("    ");
                sb.append(ejbmodule);
                sb.append("\n");
            }
        }
        if (appModuleFilters.length > 0)
        {
            sb.append("The following are available elements to monitor in appmodules <appmodule>:<ejbmodule>:<bean> \n");
            for (String appmodule: appModuleFilters)
            {
                sb.append("    ");
                sb.append(appmodule);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
    


    void verifyFilterValue() throws MonitorTaskException
    {
        if (appName != null)
        {
            final Map<String,ApplicationMonitor> appModuleMap = srm.getApplicationMonitorMap();
            if (appModuleMap.containsKey(appName))
            {
                final ApplicationMonitor am = appModuleMap.get(appName);
                final Map<String,EJBModuleMonitor> innerEJBModuleMap = am.getEJBModuleMonitorMap();
                
                final boolean exist = checkIfBeanExists(innerEJBModuleMap);
                if (!exist)
                    throw new MonitorTaskException(beanName + " does not exist in "+appName+":"+ejbName+".");
            }
            else {
                throw new MonitorTaskException(appName + " does not exist.");
            }
        }
        else
        {
            final Map<String,EJBModuleMonitor> ejbModuleMap = srm.getEJBModuleMonitorMap();
            final boolean exist = checkIfBeanExists(ejbModuleMap);
            if (!exist)
                    throw new MonitorTaskException(beanName + " does not exist in "+ejbName+".");
        }
    }
    

    abstract boolean checkIfBeanExists(final Map<String,EJBModuleMonitor> ejbModuleMap)
        throws MonitorTaskException;

    abstract List<String> getBeansInEjbModule(final String appName,
                                              final Map<String,EJBModuleMonitor> ejbModuleMap);
}
    
    

