/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Map;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.Timer;
import java.io.File;

public class ConnectionQueueMonitorTask extends MonitorTask
{
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s "+
                                         "%8$-5s %9$-5s %10$-5s";

    public ConnectionQueueMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                                      final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);
        final String title = String.format("%1$42s", "Connection Queue Monitoring");
        System.out.println(title);
        displayHeader();
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        

        final HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            cancelMonitorTask();
            return;
        }
        
            
        final ConnectionQueueMonitor connectionQueueMonitor = httpserviceMonitor.getConnectionQueueMonitor();
        if (connectionQueueMonitor == null) {
            cancelMonitorTask();
            return;
        }
        
        final ConnectionQueueStats connectionQueueStats = connectionQueueMonitor.getConnectionQueueStats();
        
        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        displayData(connectionQueueStats);
        if (verbose) counter++;
    }

    
    private void displayHeader()
    {
        final String header = String.format(displayFormat,
                                            "of","que","15a","1a","5a","tcon","tque", "id",
                                            "mque","pque");
        
        
        System.out.println(header);
        if (fileName != null)
        {
            writeToFile("CountOverflows,CountQueued,CountQueued15MinuteAverage,"+
                        "CountQueued1MinuteAverage,CountQueued5MinuteAverage,"+
                        "CountTotalConnections,CountTotalQueued,Id,MaxQueued,PeakQueued");
        }
    }

    
    private void displayData(final ConnectionQueueStats cqs)
    {
        final String data = String.format(displayFormat,
                                          cqs.getCountOverflows().getCount(),
                                          cqs.getCountQueued().getCount(),
                                          cqs.getCountQueued15MinuteAverage().getCount(),
                                          cqs.getCountQueued1MinuteAverage().getCount(),
                                          cqs.getCountQueued5MinuteAverage().getCount(),
                                          cqs.getCountTotalConnections().getCount(),
                                          cqs.getCountTotalQueued().getCount(),
                                          cqs.getID().getCurrent(),
                                          cqs.getMaxQueued().getCount(),
                                          cqs.getPeakQueued().getCount());
        
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,"+
                                              "%8$s,%9$s,%10$s",
                                              cqs.getCountOverflows().getCount(),
                                              cqs.getCountQueued().getCount(),
                                              cqs.getCountQueued15MinuteAverage().getCount(),
                                              cqs.getCountQueued1MinuteAverage().getCount(),
                                              cqs.getCountQueued5MinuteAverage().getCount(),
                                              cqs.getCountTotalConnections().getCount(),
                                              cqs.getCountTotalQueued().getCount(),
                                              cqs.getID().getCurrent(),
                                              cqs.getMaxQueued().getCount(),
                                              cqs.getPeakQueued().getCount());
            writeToFile(fileData);
        }
    }

    
    public void displayDetails()
    {
        System.out.println("**********************************************************************************");
        System.out.println("* of   = Number of times the queue has been too full to accommodate a connection *");
        System.out.println("* que  = Number of connections currently in the queue                            *");
        System.out.println("* 15a  = Average number of connections queued in the last 15 minutes             *");
        System.out.println("* 1a   = Average number of connections queued in the last 1 minute               *");
        System.out.println("* 5a   = Average number of connections queued in the last 5 minutes              *");
        System.out.println("* tcon = Total number of connections that have been accepted                     *");
        System.out.println("* tque = Total number of connections that have been queued                       *");
        System.out.println("* id   = Virtual Server ID                                                       *");
        System.out.println("* mque = Maximum size of the connection queue                                    *");
        System.out.println("* pque = Largest number of connections that were in the queue simultaneously     *");
        System.out.println("**********************************************************************************");
    }


}
    
    

