/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Map;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.Timer;
import java.io.File;

public class FileCacheMonitorTask extends MonitorTask
{
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s "+
                                         "%7$-5s %8$-5s %9$-2s %10$-5s %11$-5s %12$-5s %13$-5s "+
                                         "%14$-5s %15$-5s %16$-5s";

    public FileCacheMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                                final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);
        final String title = String.format("%1$55s", "File Cache Monitoring");
        System.out.println(title);
        displayHeader();        
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        

        final HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            cancelMonitorTask();
            return;
        }
        

        final FileCacheMonitor fileCacheMonitor = httpserviceMonitor.getFileCacheMonitor();
        if (fileCacheMonitor == null) {
            cancelMonitorTask();
            return;
        }
        
        
        final FileCacheStats fileCacheStats = fileCacheMonitor.getFileCacheStats();
        
        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        displayData(fileCacheStats);
        if (verbose) counter++;
    }

    
    private void displayHeader()
    {
        final String header = String.format(displayFormat,
                                            "cch","ccm","ce","ch","cih","cim","cm", "coe",
                                            "fe","me","mhcs","mmcs","moe","sma","shc","smc");
        System.out.println(header);
        if (fileName != null)
        {
            writeToFile("CountContentHits,CountContentMisses,CountEntries,CountHits,CountInfoHits,"+
                        "CountInfoMisses,CountMisses,CountOpenEntries,FlagEnabled,MaxEntries,"+
                        "MaxHeapCacheSize,MaxMmapCacheSize,MaxOpenEntries,SecondsMaxAge,SizeHeapCache,"+
                        "SizeMmapCache");
        }
    }

    
    private void displayData(final FileCacheStats fcs)
    {
        final String data = String.format(displayFormat,
                                          fcs.getCountContentHits().getCount(),
                                          fcs.getCountContentMisses().getCount(),
                                          fcs.getCountEntries().getCount(),
                                          fcs.getCountHits().getCount(),
                                          fcs.getCountInfoHits().getCount(),
                                          fcs.getCountInfoMisses().getCount(),
                                          fcs.getCountMisses().getCount(),
                                          fcs.getCountOpenEntries().getCount(),
                                          fcs.getFlagEnabled().getCount(),
                                          fcs.getMaxEntries().getCount(),
                                          fcs.getMaxHeapCacheSize().getCount(),
                                          fcs.getMaxMmapCacheSize().getCount(),
                                          fcs.getMaxOpenEntries().getCount(),
                                          fcs.getSecondsMaxAge().getCount(),
                                          fcs.getSizeHeapCache().getCount(),
                                          fcs.getSizeMmapCache().getCount());
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,"+
                                                  "%10$s,%11$s,%12$s,%13$s,%14$s,%15$s,%16$s",
                                                  fcs.getCountContentHits().getCount(),
                                                  fcs.getCountContentMisses().getCount(),
                                                  fcs.getCountEntries().getCount(),
                                                  fcs.getCountHits().getCount(),
                                                  fcs.getCountInfoHits().getCount(),
                                                  fcs.getCountInfoMisses().getCount(),
                                                  fcs.getCountMisses().getCount(),
                                                  fcs.getCountOpenEntries().getCount(),
                                                  fcs.getFlagEnabled().getCount(),
                                                  fcs.getMaxEntries().getCount(),
                                                  fcs.getMaxHeapCacheSize().getCount(),
                                                  fcs.getMaxMmapCacheSize().getCount(),
                                                  fcs.getMaxOpenEntries().getCount(),
                                                  fcs.getSecondsMaxAge().getCount(),
                                                  fcs.getSizeHeapCache().getCount(),
                                                  fcs.getSizeMmapCache().getCount());
            writeToFile(fileData);
        }
    }

    
    public void displayDetails()
    {
        
        System.out.println("**************************************************************");
        System.out.println("* cch  = Number of hits on cached file content               *");
        System.out.println("* ccm  = Number of misses on cached file content             *");
        System.out.println("* ce   = Number of entries currently in the cache            *");
        System.out.println("* ch   = Number of cache lookup hits                         *");
        System.out.println("* cih  = Number of hits on cached file info                  *");
        System.out.println("* cim  = Number of misses on cached file info                *");
        System.out.println("* cm   = Number of cache lookup misses                       *");
        System.out.println("* coe  = Number of entries current memory mapped             *");
        System.out.println("* fe   = Flag indicating whether file cache has been enabled *");
        System.out.println("* me   = Maximum number of open cache entries                *");
        System.out.println("* mhcs = Maximum heap space used for cache entries           *");
        System.out.println("* mmcs = Maximum heap space used for memory mapped entries   *");
        System.out.println("* moe  = Maximum number of entries currently memory mapped   *");
        System.out.println("* sma  = Maximum age of a valid cache entry                  ");
        System.out.println("* shc  = Current heap space used for cache entries           *");
        System.out.println("* smc  = Current heap space used for memory mapped entries   *");
        System.out.println("**************************************************************");
    }


}
    
    

