/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;


/**
 * Definition for the valid property
 *    @version  $Revision: 1.5 $
 */
public final class ValidProperty 
{

    // name of the property
    private String name;
    // value of the property
    private String value;
    
    /** Creates new ValidProperty */
    public ValidProperty() 
    {
    }

    /** 
	Create a new ValidProperty object with the given arguments:
	@param name name of the property
	@param value value of the property
     */
    public ValidProperty(String name, String value)
    {
        this.name = name;
        this.value = value;
    }

    /**
     * Returns the name of the property
     * @return the name of the property
     */
    public String getName() 
    {
        return name;
    }
    
    /**
     * Sets the name of the property
     * @param name the name of the property to set
     */
    public void setName(String name) 
    {
        this.name = name;
    }


    /**
     * Returns the value of the property
     * @return the value of the property
     */
    public String getValue() 
    {
        return  value;
    }
    
    /**
     * Sets the value of the property
     * @param name  the value of thhe property to set
     */
    public void setValue(String value) 
    {
        this.value = value;
    }

}
