/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;


import junit.textui.TestRunner;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.framework.Test;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.5 $
 */

public class AllTest
{

    private static final Class []classes = {
        CLILoggerTest.class,
        CommandExceptionTest.class,
        CommandFactoryTest.class,
        CommandLineParserTest.class,
        CommandTest.class,
        CommandValidatorTest.class,
        CommandValidationExceptionTest.class,
        GlobalsManagerTest.class,
        InputsAndOutputsTest.class,
        LocalStringsManagerTest.class,
        LocalStringsManagerFactoryTest.class,
        NullOutputTest.class,
        OptionsMapTest.class,
        OutputTest.class,
        UserInputTest.class,
        UserOutputImplTest.class,
        ValidCommandTest.class,
        ValidCommandsListTest.class,
        ValidOptionTest.class,
        ValidPropertyTest.class
    };
    
    public static Test suite(){
        TestSuite suite = new TestSuite("cli framework tests");
        for (int i = 0; i < classes.length; i++){
            suite.addTest(new TestSuite(classes[i]));
        }
        return suite;
    }
    
        
    public static void main(String args[]) {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(AllTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
// Local Variables:
// jde-ant-args: "-emacs -Dcover.class=All jcov.static jcov.report"
// End:
}
