/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/* 
 * $Id: MutableStatistic.java,v 1.2 2005/12/25 03:52:19 tcfujii Exp $
 * $Date: 2005/12/25 03:52:19 $
 * $Revision: 1.2 $
 */


package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Statistic;
import java.io.Serializable;

/** An interface that gives a flexibility to set various values for a particular Statistic.
 * This provision is basically to have the same data structure to collect and
 * return the (read-only copy of) statistical data. This extends the
 * java.io.Serializable, so that its subclasses can be serialized to facilitate
 * working with other management clients.
 * Refer to the package description
 * to understand the intent of this interface. 
 * <P>
 * Methods of this class should be called judiciously by the component that is 
 * gathering the statistics.
 * @author Kedar Mhaswade
 * @since S1AS8.0
 * @version 1.0
 */

public interface MutableStatistic extends Serializable {

    /** 
     * Returns a read-only view of this Statistic. An implementing class has
     * to return the instances of Statistic interfaces defined in {@link javax.management.j2ee.statistic}
     * and {@link com.sun.enterprise.admin.monitor.stats} packages.
     * @return      an instance of a specific Statistic interface
     */
    public Statistic unmodifiableView();

    /**
     * Returns an instance of Statistic whose state can be changed by the caller. It is important
     * to know that caller should not cache the return value from this method. In general, there
     * is a problem in this contract in that, a client would not know from a Stats.getCreateCount()
     * method whether the return value is something that is being modified or is invariant. Hence
     * the caller should not cache the returned value in a collection and then collectively
     * process it. The main idea behind providing this method is to control the
     * number of instances created (per Mahesh's Suggestion).
     * @return      an instance of Statistic interface that should not be cached.
     */
    public Statistic modifiableView();
    
    /** 
     * Resets the encapsulated Statistic interface to its initial value. The idea being, if (after
     * creation of the instance) the state changes, the initial state can be easily regained by
     * calling this method. Note that the time of last sampling changes to the instant
     * when this method is invoked.
     */
    public void reset();
}
