/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCKeepAliveStats.java
 *
 * Created on April 2, 2004, 10:33 AM
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 *
 * @author  nsegura
 */

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/** 
 * Provides statistical information about the HttpService HTTP-level keep-alive
 * system
 */
public interface PWCKeepAliveStats extends Stats {
    
    /** 
     * Number of connections in keep-alive mode
     * @return number of connections
     */    
    public CountStatistic getCountConnections();
    
    /** 
     * Maximum number of connections allowed in keep-alive mode simultaneously
     * @return Max number of connections allowed
     */    
    public CountStatistic getMaxConnections();
    
    /** 
     * The number of times a request was successfully received from a 
     * connection that had been kept alive
     * @return hits
     */    
    public CountStatistic getCountHits();
    
    /** 
     * The number of times the server had to close a connection because the
     * KeepAliveCount exceeded the MaxKeepAliveConnections
     * @return connections
     */    
    public CountStatistic getCountFlushes();
    
    /** 
     * The number of times the server could not hand off the connection to a 
     * keep-alive thread, possibly due to too many persistent connections
     * @return refusals
     */    
    public CountStatistic getCountRefusals();
    
    /** 
     * The number of times the server terminated keep-alive connections as the 
     * client connections timed out, without any activity
     * @return connections timed out
     */    
    public CountStatistic getCountTimeouts();
    
    /** 
     * The time (in seconds) before idle keep-alive connections are closed
     * @return time in seconds
     */    
    public CountStatistic getSecondsTimeouts();
    
}
