/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.util.proxy;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Stack;

/**
 * Represents a call stack. 
 */
public class CallStack {

    private Stack callStack = new Stack();

    /** Creates a new instance of CallStack */
    public CallStack() {
    }

    public int getStackSize() {
        return callStack.size();
    }

    public void beginCall(Method m, Object[] args) {
        Call call = new Call(m, args);
        beginCall(call);
    }

    public void beginCall(Call call) {
        callStack.push(call);
    }

    public void endCall() {
        Call call = (Call)callStack.pop();
        if (!call.getState().isFinished()) {
            call.setState(CallState.SUCCESS);
        }
    }

    public void endCallWithError(Throwable th) {
        Call call = (Call)callStack.peek();
        call.setState(CallState.FAILED);
        call.setFailureReason(th);
        endCall();
    }

    public Call getActiveCall() {
        return (Call)callStack.peek();
    }

    public Iterator getCallStack() {
        return callStack.iterator();
    }

}
