/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.ManagementRuleConfig;
import com.sun.appserv.management.config.ActionConfig;

import com.sun.enterprise.management.support.oldconfig.OldManagementRules;


/**
 */
public final class ActionConfigFactory extends ConfigFactory
{
		public
	ActionConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}
	
	    private OldManagementRules
	getOldManagementRules()
	{
	    return getOldConfigProxies().getOldManagementRules( getConfigName() );
	}

		public ObjectName
	create( final String mbeanName )
	{
        if ( mbeanName == null )
        {
            throw new IllegalArgumentException();
        }
            
	    final ManagementRuleConfig  ruleConfig  =
	        (ManagementRuleConfig)getFactoryContainer();
        
        ActionConfig actionConfig = ruleConfig.getActionConfig();
        if ( actionConfig != null )
        {
            throw new IllegalStateException( "action already exists as " +
                        actionConfig.getName() + ", " + actionConfig.getActionMBeanName());
        }
        
	    final String ruleName   = ruleConfig.getName();
        getOldManagementRules().addActionToManagementRule( ruleName, mbeanName );
	    
	    // wait till AMX version makes its appearance
        // This is clumsy, but unfortunately the MBean name is not returned by addActionToManagementRule()
	    while ( (actionConfig = ruleConfig.getActionConfig()) == null )
	    {
	        sleepMillis( 10 );
	    }
	    
	    final ObjectName    amxObjectName   = Util.getObjectName( actionConfig );
		getCallbacks().sendConfigCreatedNotification( amxObjectName );
		
	    return amxObjectName;
	}

		protected void
	internalRemove(final ObjectName	objectName)
	{
	    throw new RuntimeException( "not supported" );
	}
}




