/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;


import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.appserv.management.config.PersistenceManagerFactoryResourceConfigKeys;
import com.sun.appserv.management.config.ResourceRefConfig;

/**
	
 */
public final class PersistenceManagerFactoryResourceConfigFactory  extends ResourceFactoryImplBase
{
		public
	PersistenceManagerFactoryResourceConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}

	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		    PersistenceManagerFactoryResourceConfigKeys.FACTORY_CLASS_KEY,
		    PersistenceManagerFactoryResourceConfigKeys.JDBC_RESOURCE_JNDI_NAME_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	   
	    /**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs )
	{
		final ObjectName	objectName	=
				getOldResourcesMBean().createPersistenceManagerFactoryResource( translatedAttrs );
		
		return( objectName );
	}
	            
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( CONFIG_NAME_KEY, "jndi-name" ) );
	}
	            
	            
	/**
		Create a new &lt;persistence-resource%gt;
		
		@param jndiName				
		@param optional
	 */
		public ObjectName
	create( final String jndiName, final Map<String,String> optional)
	{
		final String[] requiredParams = new String[]{};
		final Map<String,String> params	= initParams( jndiName, requiredParams, optional );
		final ObjectName	amxName = createNamedChild( jndiName, params );
		return( amxName );
	}

		protected void
	removeByName( final String name )
	{
	    final Set<ResourceRefConfig> refs   =
	        findAllRefConfigs( XTypes.PERSISTENCE_MANAGER_FACTORY_RESOURCE_CONFIG, name );
	    
	    if ( refs.size() == 0 )
	    {
		    getOldResourcesMBean().removePersistenceManagerFactoryResourceByJndiName( name );
	    }
	    else
	    {
    	    for( final ResourceRefConfig ref : refs )
    	    {
    	        final String target = ref.getContainer().getName();
		        getOldResourcesMBean().deletePersistenceManagerFactoryResource( name, target );
    	    }
		}
    }
	
}

