/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import javax.management.MBeanServer;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.AttributeNotFoundException;

import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;

/**
	Configuration for the &lt;profiler&gt; element.
*/


public final class ProfilerConfigImpl  extends AMXConfigImplBase
{
    final Delegate mUnwrappedDelegate;  // wrapped one refuses access to "missing" attribute
    
		public
	ProfilerConfigImpl( final Delegate delegate )
	{
		super( delegate );
        
        mUnwrappedDelegate    = delegate;
	}
    
		protected ObjectName
	preRegisterModifyName(
		final MBeanServer	server,
		final ObjectName	nameIn )
	{
        final ObjectName objectName = super.preRegisterModifyName( server, nameIn );
       
        ObjectName actualObjectName = null;
        try
        {
            final String name = (String)mUnwrappedDelegate.getAttribute( "name" );
            
            actualObjectName   = JMXUtil.setKeyProperty( objectName, NAME_KEY, name );
        }
        catch( AttributeNotFoundException e )
        {
            throw new RuntimeException(e);
        }
        
        
        return actualObjectName;
    }
}