/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.ext.update;

import java.util.logging.Level;
import java.lang.reflect.Method;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.ext.update.UpdateStatus;
import com.sun.enterprise.management.support.AMXImplBase;

/**
 */
public final class UpdateStatusImpl extends AMXImplBase
    implements UpdateStatus {
        public
    UpdateStatusImpl() {
        super( );
    }

        public final String
    getGroup() {
        return( AMX.GROUP_UTILITY );
    }

        public int
    getNumModules() {

       // Even though Update Center jars are packaged with Application Server.
       // They could be un-installed. Doing a reflection based  implementation
       // is better that way. 

       int num = 0;
       try {
           final Class c = Class.forName(
            "com.sun.enterprise.update.schedule.SchedulerImpl");
           final Object s = c.newInstance();

           if (s != null) {
                // call getNumberOfModules with zero arguments
                final Class[] paramTypes = null;
                final  Object[] argTypes = null;

                final Method m = c.getMethod("runUpdateCheck", paramTypes);
                final Integer retval = (Integer) m.invoke(s, argTypes);
                num =  retval.intValue();
           }
       } catch(Throwable t) {
            getMBeanLogger().warning(t.getMessage());
            if(getMBeanLogger().isLoggable(Level.FINE))
                t.printStackTrace();

       } 
       return num;
    }

}
