/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/JVMImpl.java,v 1.6 2006/03/17 03:34:18 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/17 03:34:18 $
 */
 
package com.sun.enterprise.management.j2ee;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.InstanceNotFoundException;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.j2ee.JVM;
import com.sun.appserv.management.j2ee.J2EEServer;

import com.sun.appserv.management.j2ee.J2EETypes;

import com.sun.appserv.management.config.ServerConfig;

import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.support.Delegate;

/**
	Identifies a Java VM being utilized by a server.
 */
public final class JVMImpl
	extends J2EEManagedObjectImplBase 
{
		public
	JVMImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
		public String
	getjavaVendor()
	{
		return( (String)delegateGetAttributeNoThrow( "javaVendor" ) );
	}
	
		protected String
	getConfigPeerName()
	{
		return( AMX.NO_NAME );
	}
	
		protected String
	getConfigPeerJ2EEType()
	{
		return( XTypes.JAVA_CONFIG );
	}
	
		protected Map<String,String>
	getConfigPeerProps()
	{
		final J2EEServer	server			= (J2EEServer)getContainer();
		final ServerConfig 	serverConfig	= (ServerConfig)server.getConfigPeer();
		final String		configName		= serverConfig.getReferencedConfigName();
		
		final Map<String,String>	props	= new HashMap<String,String>();
		
		props.put( XTypes.CONFIG_CONFIG, configName );
		props.put( AMX.J2EE_TYPE_KEY, XTypes.JAVA_CONFIG );
		
		return props;
	}
	
		public String
	getjavaVersion()
	{
		return( (String)delegateGetAttributeNoThrow( "javaVersion" ) );
	}
	
		public String
	getnode()
	{
		String	fullyQualifiedHostName	= (String)delegateGetAttributeNoThrow( "node" );
		
		/*
			Underlying MBean does not comply with JSR77.3.4.1.3, which states:
			"Identifies the node (machine) this JVM is running on. The value of the node
			attribute must be the fully quailified hostname of the node the JVM is running on."
			
			value seems to be of the form: BLACK/129.150.29.138
			
			Roll our own instead.
		 */
		 try
		 {
		 	fullyQualifiedHostName	= java.net.InetAddress.getLocalHost().getCanonicalHostName();
		 }
		 catch( java.net.UnknownHostException e)
		 {
		 }
		
		return( fullyQualifiedHostName );
	}
	
	
	private final static Set<String>	DONT_MAP_SET = Collections.unmodifiableSet(
		GSetUtil.newSet( new String[] { "node", "javaVersion", "javaVendor" }) );
	
		protected Set<String>
	getDontMapAttributeNames()
	{
	    final Set<String>   all = GSetUtil.newSet( DONT_MAP_SET );
	    all.addAll( super.getDontMapAttributeNames() );
	    return( all );
	}
	

}
