/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 

package com.sun.enterprise.management.offline;

import java.io.IOException;

import javax.management.ObjectName;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;

import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateBase;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;

//import com.sun.enterprise.config.serverbeans.*;

/**
 */
class ConfigDelegate extends DelegateBase
{
    private final ConfigBeanHelper    mHelper;

    ConfigDelegate(
        final ConfigContext configContext,
        final String        xPath )
        throws ConfigException
    {
        super( "ConfigDelegate", null );
        mHelper = ConfigBeanHelperFactory.getInstance( configContext ).getHelper( xPath );
    }
    
     ConfigDelegate(
        final ConfigContext configContext,
        final ConfigBean    configBean )
        throws ConfigException
    {
        super( "ConfigDelegate", null );
        mHelper = ConfigBeanHelperFactory.getInstance( configContext ).getHelper( configBean );
    }
	
    	public Object
    getAttribute( final String attrName )
    	throws AttributeNotFoundException
    {
    	final Object  result  = mHelper.getAttribute(attrName);
    	
    	return result;
    }

    	public void
    setAttribute( final Attribute attr )
    	throws AttributeNotFoundException, InvalidAttributeValueException
    {
    	mHelper.setAttribute( attr );
    	
    	flush();
    }

    	public MBeanInfo
    getMBeanInfo()
    {
        return mHelper.getMBeanInfo();
    }
    
    
    /**
        @see com.sun.enterprise.management.config.OldPropertiesImpl
     */
        public AttributeList
    getProperties()
    {
        return mHelper.getProperties();
    }
    
     /**
        @see com.sun.enterprise.management.config.OldPropertiesImpl
     */
        public String
    getPropertyValue( final String name )
    {
        return mHelper.getPropertyValue( name );
    }
    
     /**
        @see com.sun.enterprise.management.config.OldPropertiesImpl
     */
        public void
    setProperty( final Attribute attr )
    {
        mHelper.setProperty( attr );
    }
    
     
    /**
        @see com.sun.enterprise.management.config.OldPropertiesImpl
     */
        public AttributeList
    getSystemProperties()
    {
        return mHelper.getSystemProperties();
    }
    
    
     /**
        @see com.sun.enterprise.management.config.OldPropertiesImpl
     */
        public String
    getSystemPropertyValue( final String name )
    {
        return mHelper.getSystemPropertyValue( name );
    }
    
     /**
        @see com.sun.enterprise.management.config.OldPropertiesImpl
     */
        public void
    setSystemProperty( final Attribute attr )
    {
        mHelper.setSystemProperty( attr );
    }
    
    
        public String
    getDescription()
    {
        return mHelper.getDescription();
    }
    
        public void
    setDescription( final String description )
    {
        mHelper.setDescription( description );
    }
    
    	public final Object
    invoke(
    	String 		operationName,
    	Object[]	args,
    	String[]	types )
    {
        Object  result  = null;
        final int   numArgs = args == null ? 0 : args.length;
        
        if ( "getProperties".equals( operationName ) &&
            numArgs == 0 )
        {
            result  = getProperties();
        }
        else if ( "getPropertyValue".equals( operationName ) &&
            numArgs == 1 && types[0].equals( String.class.getName() ) )
        {
            result  = getPropertyValue( (String)args[ 0 ] );
        }
        else if ( "setProperty".equals( operationName ) &&
            numArgs == 1 && types[0].equals( Attribute.class.getName() ) )
        {
            setProperty( (Attribute)args[ 0 ] );
        }
        else if ( "getSystemProperties".equals( operationName ) &&
            numArgs == 0 )
        {
            result  = getSystemProperties();
        }
        else if ( "getSystemPropertyValue".equals( operationName ) &&
            numArgs == 1 && types[0].equals( String.class.getName() ) )
        {
            result  = getSystemPropertyValue( (String)args[ 0 ] );
        }
        else if ( "setSystemProperty".equals( operationName ) &&
            numArgs == 1 && types[0].equals( Attribute.class.getName() ) )
        {
            setSystemProperty( (Attribute)args[ 0 ] );
        }
        else
        {
            result  = mHelper.handleInvoke( operationName, args, types );
        }
        
        flush();
    	
        return result;
    }
                
        private void
    flush()
    {
        try
        {
            mHelper.getConfigContext().flush();
        }
        catch (ConfigException e)
        {
            throw new RuntimeException( e );
        }
    }                
}

















