/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
 
package com.sun.enterprise.management.offline;

import java.util.Set;

import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;


final class SecurityMapConfigBeanHelper extends StdConfigBeanHelper
{
    static private final String PRINCIPAL_ATTR   = "Principal";
    static private final String USER_GROUP_ATTR   = "UserGroup";
    
        public
    SecurityMapConfigBeanHelper(
        final ConfigContext configContext,
        final ConfigBean    configBean )
    {
        super( configContext, configBean );
        
    }
    
    	public Object
    getAttribute( final String attrName )
    	throws AttributeNotFoundException
    {
        Object  result  = null;
        
        if ( PRINCIPAL_ATTR.equals( attrName ) )
        {
            result  = getPrincipalNames();
        }
        else if ( USER_GROUP_ATTR.equals( attrName ) )
        {
            result  = getUserGroupNames();
        }
        else
        {
            result  = super.getAttribute( attrName );
	    }
	    return result;
    }
    
        protected Class
    getAttributeClass( final String attrName )
    {
        Class  result  = null;
        
        if ( PRINCIPAL_ATTR.equals( attrName ) ||
            USER_GROUP_ATTR.equals( attrName ) )
        {
            result  = String[].class;
        }
        else
        {
            result  = super.getAttributeClass( attrName );
	    }
	    return result;
    }
    
        protected Set<String>
    _getAttributeNames()
    {
        final Set<String>   attrNames = super._getAttributeNames();
        
        attrNames.add( PRINCIPAL_ATTR );
        attrNames.add( USER_GROUP_ATTR );
        
        return attrNames;
    }
    
        public String[]
    getPrincipalNames()
    {
        final String    value = (String)getValue( PRINCIPAL_ATTR );
        
        // presumably spaces are not allowed in a JVM option
        final String[]  result  = (value == null) ? EMPTY_STRING_ARRAY : value.split( " " );
        
        return result;
    }
    
        public String[]
    getUserGroupNames()
    {
        final String    value = (String)getValue( USER_GROUP_ATTR );
        
        // presumably spaces are not allowed in a JVM option
        final String[]  result  = (value == null) ? EMPTY_STRING_ARRAY : value.split( " " );
        
        return result;
    }
}

















