/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/Delegate.java,v 1.3 2006/08/04 19:40:05 llc Exp $
 * $Revision: 1.3 $
 * $Date: 2006/08/04 19:40:05 $
 */

package com.sun.enterprise.management.support;

import javax.management.ObjectName;
import javax.management.MBeanInfo;
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;
import javax.management.MBeanException;



/**
	Interface for delegating responsibility for handling Attribute getters/setters
	as well as invoke().
 */
public interface Delegate
{
    /**
        An arbitrary (but hopefully meaningful) identifier
        for this Delegate.
     */
    public String   getID();
    
	public Object getAttribute( String attrName )
		throws	AttributeNotFoundException;

	public AttributeList getAttributes( final String[] attrNames );
	
	public void setAttribute( final Attribute attrName )
		throws	AttributeNotFoundException,
				InvalidAttributeValueException;
	
	public AttributeList	setAttributes( final AttributeList mappedAttrs );
	
	/**
		Return true if the Attribute is supported
	 */
	public boolean	supportsAttribute( String name );
    
    public String getDefaultValue( final String name )
		throws	AttributeNotFoundException;
	
	/**
		Return true if the operation is supported
	 */
	public boolean	supportsOperation( 
		String 		operationName,
		Object[]	args,
		String[]	types  );
	
	/**
		Get the MBeanInfo this delegate wishes to make visible.
	 */
	public MBeanInfo	getMBeanInfo();
	
	/**
		invoke the operation.
	 */
	public Object	invoke(
		String 		operationName,
		Object[]	args,
		String[]	types );
		
	
	public void	setOwner( DelegateOwner owner );
}








