/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/LBBootstrapUtil.java,v 1.3 2005/12/25 03:40:42 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:40:42 $
 */

package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.NotificationListenerBase;
import com.sun.enterprise.management.ext.lb.LoadBalancerImpl;

import java.util.Map;
import java.util.HashMap;
import java.io.IOException;
import javax.management.AttributeChangeNotification;

import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMXRootLogger;
import com.sun.enterprise.management.support.LBDeregistrationUtil;
import static com.sun.appserv.management.base.AMX.JMX_DOMAIN;

/**
 * Helps starting LBConfig listener for each LoadBalancerConfig during server 
 * startup. Server startup is a special case because MBeans for config elements 
 * can be registered in any order. Multiple LoadBalancerConfigs can refer to 
 * a single LBConfig. To  start a listener for each LoadBalancerConfig listening
 * on ATTRIBUTE_CHANGE_NOTIFICATION in the referenced LBConfig, this class waits 
 * till AMX has completed loading. The readiness of AMX loading is conveyed 
 * through the AMX_READY_NOTIFICATION. Hence this class listens for that 
 * notification type. 
 * 
 * @see LoadBalancerClusterRefRegistrationListener
 * @see LoadBalancerApplicationRefRegistrationListener
 * @see LoadBalancerRegistrationListener
 */
public class LBBootstrapUtil extends NotificationListenerBase {
    
    final static String MONITORING_ENABLED = "MonitoringEnabled";
    static boolean isInitialized = false;
    LoadBalancerRegistrationListener lbrl = null;
    final private ObjectNames objectNames = ObjectNames.getInstance(JMX_DOMAIN);        
    
    public LBBootstrapUtil(ObjectName domainRoot, MBeanServer mBeanServer)
        throws InstanceNotFoundException, IOException {
        super(mBeanServer, domainRoot, null);
    }
        
    public void handleNotification(
        final Notification notifIn, final Object handback) {
        try {
            String type = notifIn.getType();
            if ( (type == null) || 
                 (type.equals(DomainRoot.AMX_READY_NOTIFICATION_TYPE) == false) ) 
                return ;        

            //following check added just in case AMX_READY_NOTIFICATION
            //comes more than once.
            if (isInitialized) return;

            //now that all MBeans for the configs have been registered it is 
            //safe to start the following listeners that listen on new config 
            //element registrations. I store the handle of the root LB 
            //listener primarily to reuse its ability to enable / disable monitoring

            lbrl = new LoadBalancerRegistrationListener((MBeanServer)getConn());
            initRestOfLBMBeanRegistrationListeners();

            DomainConfig domainConfig = ProxyFactory.getInstance(getConn())
                                        .getDomainRoot().getDomainConfig();

            //get ALL AMX <load-balancer> mbeans in the domain
            Map<String, LoadBalancerConfig> loadBalancerConfigMap =
                domainConfig.getLoadBalancerConfigMap();
            //get ALL AMX <lb-config> mbeans in the domain
            Map<String, LBConfig> lbConfigMap = domainConfig.getLBConfigMap();

            String lbConfigName = null;
            LBConfig lbConfig = null;
            String loadBalancerName = null;
            boolean isMonitoringEnabled = false;

            for (LoadBalancerConfig loadBalancerConfig : loadBalancerConfigMap.values()) {
                loadBalancerName = loadBalancerConfig.getName();
                lbConfigName = loadBalancerConfig.getLbConfigName();
                lbConfig = lbConfigMap.get(lbConfigName);

                LoadBalancer loadBalancer = 
                    lbrl.registerLoadBalancer(loadBalancerConfig.getName());

                isMonitoringEnabled = lbConfig.getMonitoringEnabled();
                if (isMonitoringEnabled) 
                    lbrl.enableMonitoring(loadBalancerConfig.getName(), lbConfig);

                //start a listener on lbConfig for this loadBalancerConfig
                lbrl.addLBConfigListener(loadBalancerName, lbConfig);
            }
            isInitialized = true;
        } catch (Exception ex) {
            AMXRootLogger.getInstance().warning( 
                "LBBootstrapUtil:handleNotification" + " : " + ex.getMessage());           
        }
    }    

    private void initRestOfLBMBeanRegistrationListeners() {
        
        MBeanServer mbeanServer = (MBeanServer)getConn();
        try {
            new LoadBalancerClusterRefRegistrationListener(mbeanServer);
            new LoadBalancerServerRefRegistrationListener(mbeanServer);
            new LoadBalancerApplicationRefRegistrationListener(mbeanServer);
        } catch(Exception e) {
            throw new RuntimeException(e);
        }
    }	
   
}