/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;

import javax.management.ObjectName;
import javax.management.MBeanRegistration;
import javax.management.NotificationListener;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;


import com.sun.appserv.management.base.AMXMBeanLogging;

/**
	Loads MBeans. <b>INTERNAL USE ONLY</b>
 */
public interface LoaderMBean
	extends AMXSupport, MBeanRegistration, 
	NotificationListener
{
	public static final String	LOADER_NAME_PROPS	= "name=mbean-loader";
	
	
	/**
		The name of the appserver administrative domain.
		The JMX domain name is derived from this value.
	 */
	public String	getAdministrativeDomainName();
	
	/**
		The JMX domain all AMX MBeans are using.  Derived from mDomainName.
	 */
	public String	getAMXJMXDomainName();
	
	
	/**
		Start loading all MBeans.
		
		@param waitTillDone	if true, waits until started
	public void	start( final boolean waitTillDone );
	 */
	
	/**
		Check if Loader has loaded all MBeans.
		<b>Use
		{@link com.sun.appserv.management.DomainRoot#getAMXReady} instead.</b>.
		
		@return true if started, false otherwise
	 */
	public boolean	isStarted( );
	
	/**
		Synchronize with a specific MBean and return the 
		AMX MBean name for it.
	 */
	public ObjectName	sync( final ObjectName name);
	
	/**
		Wait till all outstanding AMX processing is complate.
	 */
	public void     waitAll();

	
	/**
	    Caution: code may invoke this indirectly by hard-coding the method name.
	    See com.sun.enterprise.admin.server.core.AdminService.callAMXHook()
	 */
	public void         adminServiceReady();
	
	/**
	    Applies only to those MBeans which use a Delegate MBean.
	    Unregister the AMX MBean, and re-process its delegate.
	    Used when an MBean needs to morph into another type, such
	    as a StandaloneServerConfig changing into a ClusteredServerConfig.
	 */
	public ObjectName   resyncAMXMBean( final ObjectName amxObjectName )
	                        throws InstanceNotFoundException, MBeanRegistrationException;
	
	
	/**
	    Return true if in DAS, false otherwise.
	 */
	public boolean  isDAS();
}








