/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;

import java.util.List;
import java.util.Set;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

import java.util.concurrent.ArrayBlockingQueue;

import javax.management.ObjectName;
import javax.management.MBeanRegistration;
import javax.management.NotificationListener;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;
	
final class LoaderRegThread extends Thread
{
    private static final class QueueItem
    {
        public final ObjectName mObjectName;
        public final boolean    mRegister;
        
        QueueItem( final ObjectName item, final boolean register )
        {
            mObjectName = item;
            mRegister   = register;
        }
    }
    
	private volatile boolean               mQuit;
	private ArrayBlockingQueue<QueueItem>	mQueue;
	private final Logger                    mLogger;
	private final LoaderRegHandler          mRegHandler;
	
		public
	LoaderRegThread(
		final LoaderRegHandler	regHandler,
		final Logger	logger )
	{
		mRegHandler	= regHandler;
		mLogger	= logger;
		mQuit	= false;

        final int maxElements = 512;
		mQueue		= new ArrayBlockingQueue<QueueItem>( maxElements );
	}
	
		private final Logger
	getLogger( )
	{
		return( mLogger );
	}
	
		private final void
	trace( final Object o )
	{
		if ( mLogger != null )
		{
			mLogger.finer( o.toString() );
		}
	}

		public void
	quit()
	{
		mQuit	= true;
		synchronized( this )
		{
			this.notify();
		}
	}

		public void
	enqueue(
		final boolean           register,
		final List<ObjectName>	candidates )
	{
        for( final ObjectName objectName : candidates )
		{
			enqueue( register, objectName );
		}
	}
	
		public void
	enqueue(
		final boolean		register,
		final ObjectName	theObject )
	{
        //debug( "ENQUEUE: " + (register? "register" : "unregister") + " : " + JMXUtil.toString(theObject) );
        try
        {
            mQueue.put( new QueueItem( theObject, register ) );
        }
        catch( InterruptedException e )
        {
            mQuit   = true;
        }
	}

		public void
	run()
	{
		mQuit	= false;
		
		while ( ! mQuit )
		{
			try
            {
                process();
            }
            catch( InterruptedException e )
            {
                mQuit   = true;
            }
		}
	}
	
    
		protected boolean
	mySleep( final long millis )
	{
		boolean	interrupted	= false;
		
		try
		{
			Thread.sleep( millis );
		}
		catch( InterruptedException e )
		{
			Thread.interrupted();
			interrupted	= true;
		}
		
		return interrupted;
	}

    /** to support waitAll()--a best effort indicator */
    private volatile QueueItem   mInProgress = null;
    
    /**
        Wait for all outstanding requests to be finished.
        A best-effort method; not a 100% guarantee, but that's also
        true if something is queued right after the call!
     */
		public void
	waitAll()
	{
        while ( mQueue.size() != 0 || mInProgress != null )
        {
			mySleep( 100 );
        }
	}

		private void
	processRegistration( final ObjectName objectName )
	{
		try
		{
			mRegHandler.handleMBeanRegistered( objectName );
			getLogger().finer( "LoaderRegThread.processRegistration: processed mbean: " + objectName );
		}
		catch( Throwable t )
		{
			getLogger().warning( "LoaderRegThread.processRegistration: " +
				"registration of MBean failed for: " + 
				objectName + " = " + t.toString() + ", " + t.getMessage() + "\n" +
				ExceptionUtil.getStackTrace( t ) );
		}
	}
	
		private void
	processUnregistration( final ObjectName objectName )
	{
		try
		{
			mRegHandler.handleMBeanUnregistered( objectName );
		}
		catch( Throwable t )
		{
			getLogger().warning( "LoaderRegThread.processUnregistration: " +
				"unregistration of MBean failed for: " + 
				objectName + " = " + t.toString() );
		}
	}
        
        public boolean
    isQueueEmpty()
    {
        return mQueue.size() == 0;
    }
	
		private void
	process()
        throws InterruptedException
	{
		while ( ! mQuit  )
		{
            mInProgress = mQueue.take();
            if ( mInProgress == null )
            {
                mQuit   = true; // a null item signals that we should quit
            }
            
            //debug( "PROCESS: " + (item.mRegister? "register" : "unregister") + " : " + JMXUtil.toString(item.mObjectName) );
            
            if ( mInProgress.mRegister )
            {
                processRegistration( mInProgress.mObjectName );
            }
            else
            {
                processUnregistration( mInProgress.mObjectName );
            }
            mInProgress = null;
		}
	}
}












