/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management;

import java.util.Map;
import java.io.Serializable;

import javax.management.ObjectName;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ListenerNotFoundException;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.appserv.management.util.misc.TypeCast;

	
/**
	A NotificationListener which expects to receive a 
	CONFIG_CREATED_NOTIFICATION_TYPE and CONFIG_REMOVED_NOTIFICATION_TYPE
	from an MBean with a particular j2eeType and name.
 */
public final class CreateRemoveListener implements NotificationListener
{
	private final String		mNameExpected;
	private final String		mJ2EETypeExpected;
	private final Container		mSource;
	
	private Notification	mCreateNotif;
	private Notification	mRemoveNotif;
	
		public
	CreateRemoveListener(
		final Container		source,
		final String		j2eeTypeExpected,
		final String		nameExpected )
	{
		mSource				= source;
		mNameExpected		= nameExpected;
		mJ2EETypeExpected	= j2eeTypeExpected;
		
		mSource.addNotificationListener( this, null, null );
	}
	
		public void
	handleNotification(
		final Notification	notifIn, 
		final Object		handback)
	{
		final String	type	= notifIn.getType();

		//final Map<String,Serializable>	m	= getAMXNotificationData * notifIn );
		final ObjectName	objectName	=
		    Util.getAMXNotificationValue( notifIn, AMXConfig.CONFIG_OBJECT_NAME_KEY, ObjectName.class );
		
		//trace( "CreateRemoveListener:\n" + SmartStringifier.toString( notifIn ) + ":\n" + objectName );
			
		if ( Util.getJ2EEType( objectName ).equals( mJ2EETypeExpected )  &&
			Util.getName( objectName ).equals( mNameExpected ) )
		{
			if ( type.equals( AMXConfig.CONFIG_CREATED_NOTIFICATION_TYPE ) )
			{
				mCreateNotif	= notifIn;
			}
			else if ( type.equals( AMXConfig.CONFIG_REMOVED_NOTIFICATION_TYPE ) )
			{
				mRemoveNotif	= notifIn;
			}
		}
	}
			protected void
	trace( Object o )
	{
		System.out.println( SmartStringifier.toString( o ) );
	}
	
		public void
	waitCreate()
	{
		long	millis	= 10;
		
		while ( mCreateNotif == null )
		{
			AMXTestBase.mySleep( millis );
			trace( "waiting " + millis + "ms for CONFIG_CREATED_NOTIFICATION_TYPE for " + mNameExpected);
			millis	*= 2;
		}
	}
	
		public void
	waitRemove()
	{
		long	millis	= 10;
		while ( mRemoveNotif == null )
		{
			AMXTestBase.mySleep( millis );
			trace( "waiting " + millis + "ms for CONFIG_REMOVED_NOTIFICATION_TYPE for " + mNameExpected);
			millis	*= 2;
		}
	}
	
	
		public void
	waitNotifs()
	{
		waitCreate();
		waitRemove();
		
		try
		{
			mSource.removeNotificationListener( (NotificationListener)this, null, null );
		}
		catch( ListenerNotFoundException e )
		{
			throw new RuntimeException( e );
		}
	}
}