/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.base;

import java.io.IOException;

import javax.management.ObjectName;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanServerConnection;

import com.sun.appserv.management.base.Util;

import com.sun.enterprise.management.support.TestDummy;
import com.sun.enterprise.management.support.TestDummyMBean;

import com.sun.enterprise.management.util.jmx.JMXTestBase;


/**
 */
public final class NotificationPerformanceTest extends JMXTestBase
{
    // built-into server already
    private static final String IMPL_CLASSNAME = TestDummy.class.getName();
    
		public
	NotificationPerformanceTest( )
	{
	}
	
	    private ObjectName
	createTestDummy( final String name )
	    throws JMException, IOException
	{
	    ObjectName objectName =
	        Util.newObjectName( "NotificationPerformanceTest:name=" + name );
	    
	    final MBeanServerConnection conn = getMBeanServerConnection();
	    
	    if ( ! conn.isRegistered( objectName ) )
	    {
    	    objectName  =
    	        conn.createMBean( IMPL_CLASSNAME, objectName ).getObjectName();
	    }
	    
	    return objectName;
	}
	
	    public void
	testNotificationPerformance()
	    throws JMException, IOException
	{
	    final ObjectName    objectName  = createTestDummy( "testNotificationPerformance" );
	    
	    final TestDummyMBean  test  = newProxy( objectName, TestDummyMBean.class );
	    
	    final int   ITER    = 10;
	    final int   COUNT   = 1024 * 1024;
	    
	    for( int iter = 0; iter < ITER; ++iter )
	    {
    	    final long elapsed  =
    	        test.emitNotifications( "NotificationPerformanceTest.test", COUNT );
    	    
    	    final float rate    = (elapsed == 0) ? (float)0.0 : (1000 * ((float)COUNT / (float)elapsed));
    	    final String rateString = (elapsed == 0) ? "N/A" : "" + (int)rate;
    	    
    	    System.out.println( "Millis to emit " + COUNT + " Notifications: " + elapsed + 
    		    " = " + rateString + " notifications/sec" );
	    }
	}
}


























