/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;


import com.sun.appserv.management.config.AvailabilityServiceConfig;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.ClusterSupportRequired;

import javax.management.InstanceNotFoundException;


public class AvailabilityServiceConfigTest extends AMXTestBase
    implements ClusterSupportRequired
{
	public AvailabilityServiceConfigTest()
        throws InstanceNotFoundException
	{
	}
	
	    private AvailabilityServiceConfig
	getIt()
	{
		return getConfigConfig().getAvailabilityServiceConfig();
	}
        
        public void
    testWarnAvail()
    {
        if ( getIt() == null )
        {
            assert false : "AvailabilityServiceConfigTest:  no AvailabilityServiceConfig to test";
        }
    }
			
	/**
	 * Test of [g/s]etAvailabilityEnabled method, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testAvailabilityEnabled()
	{
        if ( getIt() != null )
        {
            getIt().setAvailabilityEnabled(false);
            assertFalse("getAvailabilityEnabled() was supposed to return false.", getIt().getAvailabilityEnabled());
            getIt().setAvailabilityEnabled(true);
            assertTrue("getAvailabilityEnabled() was supposed to return true.", getIt().getAvailabilityEnabled());
        }
	}

	/**
	 * Test of [g/s]etAutoManageHAStore method, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testAutoManageHAStore()
	{
        if ( getIt() != null )
        {
            final boolean save = getIt().getAutoManageHAStore();
            getIt().setAutoManageHAStore(true);
            assertTrue("getAutoManageHAStore() was supposed to return true.", getIt().getAutoManageHAStore());
            getIt().setAutoManageHAStore(false);
            assertFalse("getAutoManageHAStore() was supposed to return false.", getIt().getAutoManageHAStore());
            getIt().setAutoManageHAStore(save);
        }
	}

	/**
	 * Test of [g/s]etHAAgentHosts methods, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testHAAgentHosts()
	{
        if ( getIt() != null )
        {
            final String hosts = "hp,hp,hp,hp";
            final String save = getIt().getHAAgentHosts();
            getIt().setHAAgentHosts(hosts);
            String s = getIt().getHAAgentHosts();
            assertEquals(hosts, s);
            getIt().setHAAgentHosts( (save == null) ? "" : save);
        }
	}

	/**
	 * Test of [g/s]etHAAgentPort methods, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testHAAgentPort()
	{
        if ( getIt() != null )
        {
            final String port = "3456";
            final String save = getIt().getHAAgentPort();
            getIt().setHAAgentPort(port);
            final String s = getIt().getHAAgentPort();
            assertEquals(port, s);
            getIt().setHAAgentPort( (save == null) ? "" : save);
        }
	}

	/**
	 * Test of [g/s]etHAStoreHealthcheckIntervalSeconds methods, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testHAStoreHealthcheckIntervalSeconds()
	{
        if ( getIt() != null )
        {
            final String time = "90";
            final String save = getIt().getHAStoreHealthcheckIntervalSeconds();
            getIt().setHAStoreHealthcheckIntervalSeconds(time);
            String s = getIt().getHAStoreHealthcheckIntervalSeconds();
            assertEquals(time, s);
            getIt().setHAStoreHealthcheckIntervalSeconds( (save == null) ? "" : save);
        }
	}

	/**
	 * Test of [g/s]etHAStoreName methods, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testHAStoreName()
	{
        if ( getIt() != null )
        {
            final String storeName = "cluster1";
            final String save = getIt().getHAStoreName();
            getIt().setHAStoreName(storeName);
            final String s = getIt().getHAStoreName();
            assertEquals(storeName, s);
            getIt().setHAStoreName( (save == null) ? "" : save);
        }
	}
	
	/**
	 * Test of [g/s]etStorePoolName methods, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testStorePoolName()
	{
        if ( getIt() != null )
        {
            final String storeName = "xxxx";
            final String save = getIt().getStorePoolName();
            getIt().setStorePoolName(storeName);
            final String s = getIt().getStorePoolName();
            assertEquals(storeName, s);
            getIt().setStorePoolName( (save == null) ? "" : save);
        }
	}

	/**
	 * Test of [g/s]etHAStoreHealthcheckEnabled methods, of class com.sun.appserv.management.config.AvailabilityServiceConfig.
	 */
	public void testHAStoreHealthcheckEnabled()
	{
        if ( getIt() != null )
        {
            final boolean save = getIt().getHAStoreHealthcheckEnabled();
            
            getIt().setHAStoreHealthcheckEnabled(false);
            assertFalse("getHAStoreHealthcheckEnabled() was supposed to return false.", getIt().getHAStoreHealthcheckEnabled());
            getIt().setHAStoreHealthcheckEnabled(true);
            assertTrue("getHAStoreHealthcheckEnabled() was supposed to return true.", getIt().getHAStoreHealthcheckEnabled());
            getIt().setHAStoreHealthcheckEnabled( save );
        }
	}
}


