/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.config.ProfilerConfig;
import com.sun.appserv.management.config.ProfilerConfigKeys;

import com.sun.appserv.management.util.jmx.JMXUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class ProfilerConfigTest extends AMXTestBase
{
	private static final String	NATIVE_LIBRARY_PATH	= "a/b/c";
	private static final String	CLASSPATH	= "/foo/bar";
	
	    private static Map<String,String>
	getOptional()
	{
	    final Map<String,String> optional    = new HashMap<String,String>();
	    optional.put( ProfilerConfigKeys.NATIVE_LIBRARY_PATH_KEY, NATIVE_LIBRARY_PATH);
	    optional.put( ProfilerConfigKeys.CLASSPATH_KEY, CLASSPATH);
	    optional.put( ProfilerConfigKeys.ENABLED_KEY, "false");
	    return optional;
	}

		public
	ProfilerConfigTest ()
	{
	    if ( checkNotOffline( "testIllegalCreate" ) )
	    {
	        ensureDefaultInstance( getConfigConfig().getJavaConfig() );
	    }
	}
	
		public static ProfilerConfig
	ensureDefaultInstance( final JavaConfig javaConfig )
	{
		ProfilerConfig	prof	= javaConfig.getProfilerConfig( );
		if ( prof == null )
		{
			final String	NAME	= "profiler";
			
			prof = javaConfig.createProfilerConfig( NAME, getOptional() );
			assert prof != null;
		}
		
		return prof;
	}
	
	    private void
	testGetters( final ProfilerConfig prof )
	{
	    assert( prof.getClasspath() != null );
	    prof.setClasspath( prof.getClasspath() );
	    
	    assert( prof.getNativeLibraryPath() != null );
	    prof.setNativeLibraryPath( prof.getNativeLibraryPath() );
	    
	    assert( prof.getJVMOptions() != null );
	    prof.setJVMOptions( prof.getJVMOptions() );
	    
	    prof.setEnabled( prof.getEnabled() );
	}
	
		public synchronized void
	testCreateRemoveProfiler()
		throws Exception
	{
	    if ( checkNotOffline( "testIllegalCreate" ) )
	    {
	        ensureDefaultInstance( getConfigConfig().getJavaConfig() );
	        
    	    final JavaConfig    javaConfig    = getConfigConfig().getJavaConfig();
    		
    		javaConfig.removeProfilerConfig();
    		assert javaConfig.getProfilerConfig() == null :
    		    "Can't remove ProfilerConfig from " +
    		        JMXUtil.toString( Util.getObjectName(javaConfig) );
    		
    		ensureDefaultInstance( javaConfig );
    		assert javaConfig.getProfilerConfig() != null;
    		Util.getExtra( javaConfig.getProfilerConfig() ).getMBeanInfo();
    		
    		testGetters( javaConfig.getProfilerConfig() );
    		
    		javaConfig.removeProfilerConfig();
    		ensureDefaultInstance( javaConfig );
    		assert javaConfig.getProfilerConfig() != null;
    		Util.getExtra( javaConfig.getProfilerConfig() ).getMBeanInfo();
    		testGetters( javaConfig.getProfilerConfig() );
		}
	}
}


