/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.Iterator;

import java.io.IOException;

import javax.management.ObjectName;

import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class SystemPropertiesAccessTest extends AMXTestBase
{
		public
	SystemPropertiesAccessTest( )
	{
	}
	
		private Set<ObjectName>
	getAll()
		throws Exception
	{
		final Set<ObjectName>	objectNames	=
		    getQueryMgr().queryInterfaceObjectNameSet(
			    SystemPropertiesAccess.class.getName(), null);
	    
		return( objectNames );
	}
	
	
		private void
	checkPropertiesGet( final SystemPropertiesAccess props )
	{
	    final Map<String,String>    all = props.getSystemProperties();
	    
		final String[]	propNames			= props.getSystemPropertyNames();
		
		for( final String name : propNames )
		{
		    assert( props.existsSystemProperty( name ) );
			final String	value	= props.getSystemPropertyValue( name );
		}
	}
	
		private void
	testPropertiesSetToSameValue( final SystemPropertiesAccess props )
	{
		final String[]	propNames			= props.getSystemPropertyNames();
		
		// get each property, set it to the same value, the verify
		// it's the same.
		for( int i = 0; i < propNames.length; ++i )
		{
			final String	propName	= propNames[ i ];
			
			final String	value	= props.getSystemPropertyValue( propName );
			props.setSystemPropertyValue( propName, value );
			
			assert( props.getSystemPropertyValue( propName ).equals( value ) );
		}
	}
	
		private void
	testCreateEmptySystemProperty( final SystemPropertiesAccess props )
	{
	    final String NAME   = "test.empty";
	    
		props.createSystemProperty( NAME, "" );
		assert( props.existsSystemProperty( NAME ) );
		props.removeSystemProperty( NAME );
		assert( ! props.existsSystemProperty( NAME ) );
	}
	
		private void
	testSystemPropertiesCreateRemove( final SystemPropertiesAccess props )
	{
		final String[]	propNames			= props.getSystemPropertyNames();
		
		// add some properties, then delete them
		final int	numToAdd	= 1;
		final long	now	= System.currentTimeMillis();
		for( int i = 0; i < numToAdd; ++i )
		{
			final String	testName	= "__junittest_" + i + now;
			
			if ( props.existsSystemProperty( testName ) )
			{
				failure( "test property already exists: " + testName );
			}
			
			props.createSystemProperty( testName, "value_" + i );
			assert( props.existsSystemProperty( testName ) );
		}
		final int	numProps	= props.getSystemPropertyNames().length;
		
		if ( numProps != numToAdd + propNames.length )
		{
			failure( "expecting " + numProps + " have " + numToAdd + propNames.length );
		}
		
		
		// remove the ones we added
		for( int i = 0; i < numToAdd; ++i )
		{
			final String	testName	= "__junittest_" + i + now;
			
			props.removeSystemProperty( testName );
			assert( ! props.existsSystemProperty( testName ) );
		}
		
		assert( props.getSystemPropertyNames().length == propNames.length );
		
	}
	
		public synchronized void
	checkGetProperties( final ObjectName src )
		throws Exception
	{
		final AMX	proxy	= getProxy( src, AMX.class);
		
		if ( ! (proxy instanceof SystemPropertiesAccess) )
		{
			throw new IllegalArgumentException(
				"MBean does not implement SystemPropertiesAccess: " + quote( src ) );
		}
		
		final SystemPropertiesAccess	props	= (SystemPropertiesAccess)proxy;
		checkPropertiesGet( props );
	}
	
		public void
	checkSetPropertiesSetToSameValue( final ObjectName src )
		throws Exception
	{
		final SystemPropertiesAccess	props	= getProxy( src, SystemPropertiesAccess.class );
		
		testPropertiesSetToSameValue( props );
	}
	
	
		public void
	checkCreateRemove( final ObjectName src )
		throws Exception
	{
		final SystemPropertiesAccess	props	=
		    getProxy( src, SystemPropertiesAccess.class );
		
		testSystemPropertiesCreateRemove( props );
	}

		public synchronized void
	testPropertiesGet()
		throws Exception
	{
		final Set<ObjectName>	all	= getAll();
		
		testAll( all, "checkGetProperties" );
	}
	
		public synchronized  void
	testPropertiesSetToSameValue()
		throws Exception
	{
		final Set<ObjectName>	all	= getAll();
		
		testAll( all, "checkSetPropertiesSetToSameValue" );
	}
	
	
		public synchronized void
	testCreateRemove()
		throws Exception
	{
	    if ( checkNotOffline( "testCreateRemove" ) )
	    {
    		final Set<ObjectName>	all	= getAll();
    		testAll( all, "checkCreateRemove" );
	    }
	}
	
}


