/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.server.core.AdminService;
 
import javax.management.ObjectName;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
//import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import java.util.ArrayList;
import java.util.logging.Level; 
import java.util.logging.Logger;

/**
 * object name for this mbean: 
 * <domainName>:type=transaction-service-manager,category=config
 * Based on the target calls the appropriate mbean
 *
 * @author sridatta
 *
 */
public class TransactionServiceManagerMBean extends BaseConfigMBean
{
    private static final TargetType[] VALID_TARGET_TYPES = new TargetType[] {
        TargetType.UNCLUSTERED_SERVER, TargetType.DAS, TargetType.SERVER};
        
    public TransactionServiceManagerMBean()
    {
        super();
    }	
    
	///////////////////////////////////////////////////////////////////////////
      public void freeze(String serverName) throws Exception {
          finest("freeze called for target: " + serverName);
          validateServerName(serverName);
          try {
                  getMBS().invoke(getTransactionServiceObjectName(serverName), "freeze", null, null);
          } catch(javax.management.InstanceNotFoundException  e) {
                 throw new MBeanException(e, _strMgr.getString("admin.mbeans.server_not_running", new Object[] {serverName})); 
          }
      }
      
      public void unfreeze(String serverName) throws Exception {
          finest("unfreeze called for target: " + serverName);
          validateServerName(serverName);
          try {
              getMBS().invoke(getTransactionServiceObjectName(serverName), "unfreeze", null, null);
          } catch(javax.management.InstanceNotFoundException  e) {
                 throw new MBeanException(e, _strMgr.getString("admin.mbeans.server_not_running", new Object[] {serverName})); 
          }
      }
      public void rollback(String[] txids, String serverName)
                            throws Exception {
          finest("rollback called for target: " + serverName);
          validateServerName(serverName);
          try {
              getMBS().invoke(getTransactionServiceObjectName(serverName), 
                        "rollback", 
                        new Object[] {txids},
                        new String[] {"[Ljava.lang.String;"});
          } catch(javax.management.InstanceNotFoundException  e) {
                 throw new MBeanException(e, _strMgr.getString("admin.mbeans.server_not_running", new Object[] {serverName})); 
          }
      }
      
      
      ///////////////////////////////////////////////////////////////////////////
     
      private MBeanServer getMBS() {
         return com.sun.enterprise.admin.common.MBeanServerFactory.getMBeanServer();
      }      
      
      private ObjectName getTransactionServiceObjectName(String server) 
                                                throws Exception {
          return new ObjectName(
                getDomainName() + 
                ":type=TransactionService,J2EEServer=" 
                + server 
                + ",category=runtime"); 
      }
     
   private void validateServerName(String server) throws Exception {
       finest("validating the target " + server);
         final Target target = TargetBuilder.INSTANCE.createTarget(
                VALID_TARGET_TYPES,  
                server, getConfigContext());
         finest("Target is valid: " + server);
   }
   
   //We must subclass this method, because the base case seems to return a null config context if
    //the mbean does not have a corresponding xpath (or something). The properties MBean seems
    //to have this problem.
    protected ConfigContext getConfigContext()
    {
        ConfigContext result = super.getConfigContext();
        if (result == null) {
            result = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        }
        return result;
    }

   private void finest(String  s) {
       _logger.finest("TransactionServiceManagerMBean: " + s); 
   }
     
	///////////////////////////////////////////////////////////////////////////
	
	private static final	StringManager	_strMgr = 
               StringManager.getManager(TransactionServiceManagerMBean.class);
       public static final Logger _logger = Logger.getLogger(AdminConstants.kLoggerName);

	///////////////////////////////////////////////////////////////////////////
                
}
