/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import javax.management.*;
import java.util.Set;
import java.util.HashSet;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
//import javax.rmi.PortableRemoteObject;
import javax.naming.*;

/**
 * The base class for Managed Objects that are event providers
 */

public abstract class J2EEEventProviderMOMdl extends J2EEManagedObjectMdl implements NotificationBroadcaster {
    
    private final NotificationBroadcasterSupport broadcaster;
    private final boolean debug = false;
    public J2EEEventProviderMOMdl(String name,boolean state, boolean statistics) {
        super(name,state,statistics,false);
        broadcaster = new NotificationBroadcasterSupport();
    }
    public J2EEEventProviderMOMdl(String name,String serverName,boolean state, boolean statistics) {
        super(name,serverName,state,statistics,false);
        broadcaster = new NotificationBroadcasterSupport();
    }
    public void addNotificationListener(NotificationListener listener,
                                    NotificationFilter filter,
                                    java.lang.Object handback){
        if(debug)System.out.println("J2EEEventPRoviderMOMdl::addNotificationListener listener added:"+listener);
        broadcaster.addNotificationListener(listener,filter,handback);
    }
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException{
        broadcaster.removeNotificationListener(listener);
    }
    public MBeanNotificationInfo[] getNotificationInfo(){
        return broadcaster.getNotificationInfo();
    }
    public void sendNotification(Notification notification){
        if(debug)System.out.println("J2EEEventPRoviderMOMdl::sendNotification sending notification"+notification);
        broadcaster.sendNotification(notification);
    }    
}
