/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JCAManagedConnectionFactory.java
 *
 * Created on March 5, 2002, 4:02 PM
 */

package com.sun.enterprise.management.model;

import javax.management.ObjectName;
import java.util.Set;

public class JCAManagedConnectionFactoryMdl extends J2EEManagedObjectMdl {

    private static String MANAGED_OBJECT_TYPE = "JCAManagedConnectionFactory";
    private String jcaConnectionFactoryName = null;
    /** Creates new JCAManagedConnectionFactory */
    public JCAManagedConnectionFactoryMdl(String connFactName) {
        super(connFactName,false,false,false);
        this.jcaConnectionFactoryName = connFactName;
    }
    public JCAManagedConnectionFactoryMdl(String connFactName, String serverName) {
        super(connFactName, serverName, false,false,false);
        this.jcaConnectionFactoryName = connFactName;
    }

    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this
     * method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
     /*
    public String getobjectName() {
        Set s = findNames("j2eeType="+getj2eeType()+",name="+this.jcaConnectionFactoryName+",J2EEServer="+getJ2EEServer());
        Object [] objs = s.toArray();
        if (objs.length > 0) {
        	String name = ((ObjectName)objs[0]).toString();
        	return name;
        } else {
            return null;
        }
    }
    */
    
}
