/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

//import com.sun.enterprise.resource.JdbcDataSource;

import java.util.Set;
import javax.management.ObjectName;

public class JDBCDataSourceMdl extends J2EEManagedObjectMdl {

    private static String MANAGED_OBJECT_TYPE = "JDBCDataSource";
    private String jdbcDataSourceName = null;
    private String driverName = null;
    private boolean debug = false;
    private String username = null;
    private String password = null;
    private String url = null;
    private String[] propNames = null;
    private String[] propValues = null;
    
    public JDBCDataSourceMdl(String dataSourceJndiName, String dataSourceName,
                            String url,
                            String username, 
                            String password,
                            String[] propNames, 
                            String[] propValues) {
        super(dataSourceJndiName,false,false,false);
        this.jdbcDataSourceName = dataSourceName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.propNames = propNames;
        this.propValues = propValues;
    }
    public JDBCDataSourceMdl(String dataSourceJndiName, String serverName, String dataSourceName,
                            String url,
                            String username, 
                            String password,
                            String[] propNames, 
                            String[] propValues) {
        super(dataSourceJndiName,serverName,false,false,false);
        this.jdbcDataSourceName = dataSourceName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.propNames = propNames;
        this.propValues = propValues;
    }

    public String getjdbcDriver() {
        if (driverName == null) {
            Set s;
        	try {
            	//System.out.println("getjdbcDriver: jdbcDataSourceName = " + jdbcDataSourceName);
            	java.sql.Driver drv = java.sql.DriverManager.getDriver(jdbcDataSourceName);
            	//System.out.println("java.sql.Driver = " + drv.getClass().getName());
				s = findNames("j2eeType=JDBCDriver,name="+drv.getClass().getName());
        	} catch(java.sql.SQLException e) {
                //XADataSource
                s = findNames("j2eeType=JDBCDriver,name="+jdbcDataSourceName);
        	}

        	Object [] objs = s.toArray();
        	if (objs.length > 0) {
        		String name = ((ObjectName)objs[0]).toString();
        		driverName = name;
        	}
        }
        return driverName;
    }
    
    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
     /*
    public String getobjectName() {
        Set s = findNames("j2eeType="+getj2eeType()+",name="+this.getname()+",JDBCResource="+getJDBC()+",J2EEServer="+this.getJ2EEServer());
        Object [] objs = s.toArray();
        if (objs.length > 0) {
        	String name = ((ObjectName)objs[0]).toString();
        	return name;
        } else {
            return null;
        }
    }
    */

    /**
     * Accessor method for the parent key
     */
    public String getJDBC(){
		return getname(); //matches name of JDBCResource in this impl
    }
    
    public String geturl() {
        return url;
    }
  
    public String getusername() {
        return username;
    }

    public String getpassword() {
        return password;
    }

    public String[] getpropNames() {
        return propNames;
    }

    public String[] getpropValues() {
        return propValues;
    }
    
    public String getjdbcDataSourceName() {
        return jdbcDataSourceName;
    }
}
