/*
 * AsyncHandler.java
 *
 * Created on June 16, 2006, 12:30 PM
 *
 */

package com.sun.enterprise.admin.monitor.callflow;

/**
 * This interface is producer responsible for populating queues that will be
 * asynchronously written to the database by a consumer thread. That is,
 * a separate asynchronous thread is used to write data to the data base.
 *
 * Producers aka AgentImpl get a handle to AsyncHandler through a factory. A
 * singleton pattern is enforced on the impl of this interface.
 *
 * @author Harpreet Singh
 */

public interface AsyncHandlerIntf {
    
    void enable();
    void disable();
    
    void handleRequestStart(
            String requestId, long timeStamp, long timeStampMillis,
            RequestType requestType, String callerIPAddress,
            String remoteUser);
    
    void handleRequestEnd(String requestId, long timeStamp);
    
    void handleMethodStart(
            String requestId, long timeStamp, String methodName,
            ComponentType componentType, String applicationName,
            String moduleName, String componentName, String threadId,
            String transactionId, String securityId);
    
    void handleMethodEnd(String requestId, long timeStamp, Throwable exception);
    
    void handleStartTime(String requestId, long timeStamp,
            ContainerTypeOrApplicationType type);
    
    void handleEndTime(String requestId, long timeStamp,
            ContainerTypeOrApplicationType type);
    public void flush ();
    
}
