/*
 * ConsumerQProcessor.java
 *
 * Created on June 22, 2006, 1:34 PM
 *
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;

/**
 *
 * @todo Add logging code
 * @todo replace this thread by the ORB Thread Pool Thread
 * @author Harpreet Singh
 */
public class ConsumerQProcessor implements Runnable{
    
    BlockingQueue consumerQ;
    private DbAccessObject dbAccessObject;    
    boolean processQ = true;
    private int sleepTime = 30000;
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    private static final String CONSUMER_SLEEP_TIME = 
            "com.sun.enterprise.callflow.sleepms";
    // special callflow debug flag
    boolean traceOn = false;
    // handle to the handler chain
    private HandlerChain chain;
    
    private long numOfQueuesProcessed = 0;
    private long numOfTimesQSlept = 0;
    /**
     * Creates a new instance of ConsumerQProcessor
     */
    public ConsumerQProcessor(BlockingQueue<CallflowProducerQueue> consumerQ, 
            HandlerChain chain) {
        this.consumerQ = consumerQ;
        this.chain = chain;
        dbAccessObject = DbAccessObjectImpl.getInstance();
        traceOn = TraceOnHelper.isTraceOn();
        sleepTime = Math.abs(Integer.getInteger(CONSUMER_SLEEP_TIME, 5000));
    }
    public void stopConsumerThread (){
        processQ = false;
        if (traceOn){
            logger.log (Level.INFO, "Callflow: ConsumerQProcessor.stopConsumerThread ");
        }
    }

    public void run() {
        if (traceOn)
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.entering run ");

        while (processQ){
            if(!consumerQ.isEmpty()){
                consume ();
            } else{
                try {
                    if (traceOn){
                        logger.log(Level.INFO, "Callflow: ConsumerQProcessor." +
                                "Q Empty, sleeping for "+ getSleepTime () + 
                                " ms. Sleeping for the "+getNumOfTimesQSlept()
                                + " th time.");
                    }
                    this.numOfTimesQSlept++;
                    Thread.sleep(getSleepTime());
                } catch (InterruptedException e){
                    if (processQ == false){
                        // do not quit abruptly. Process any items remaining in
                        // queues before quitting.
                        if (traceOn)
                            logger.log(Level.INFO, "Callflow: ConsumerQProcessor." +
                                "Disable Called, forcing consumption");

                        break;
                    }
                }
            }
            
        }
        // force consumption
        consume();
        if (traceOn){
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.exiting run. "+
                    " Num of Entries Processed for each table \n"+
                    this.dbAccessObject.getNumOfRequestsProcessedAsString()
                    +" \n");
            
        }
    }
    void consume (){
        int noOfQueues = consumerQ.size ();
        numOfQueuesProcessed += noOfQueues;
        if (traceOn){
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.consume. "+
                    "ConsumerQ.length ="+ noOfQueues + ". Total number of " +
                    " Q's Processed = "+ numOfQueuesProcessed);
        }

        for (int i = 0; i<noOfQueues; i++){
            CallflowProducerQueue q =  (CallflowProducerQueue) consumerQ.poll();
            if (q != null){
                if (traceOn){
                    logger.log(Level.INFO, "Callflow: ConsumerQProcessor.processProducerQ "+
                            q.getName());
                }
                TransferObject[] to = q.getAndRemoveAll();
                if (to != null){
                    Handler[] handler = chain.getHandlers();
                    for (int j=0;j<handler.length;j++ ){
                        if (traceOn){
                            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.processProducerQ "+
                                    handler[j]);
                        }
                        handler[j].handle(to);
                    }
                }
            }
        }
   }
    /**
     * consumes the ConsumerQ. Returns the number of Q's processed
     */
//    int consume() {
//        int noOfQueues = consumerQ.size();
//        numOfQueuesProcessed += noOfQueues;
//        if (traceOn){
//            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.consume. "+
//                    "ConsumerQ.length ="+ noOfQueues + ". Total number of " +
//                    " Q's Processed = "+ numOfQueuesProcessed);
//        }
//        for (int i = 0; i<noOfQueues; i++){
//            CallflowProducerQueue q =  (CallflowProducerQueue) consumerQ.poll();
//            if (q != null)
//                processProducerQ(q);
//        }
//        return noOfQueues;
//    }

//    void processProducerQ(CallflowProducerQueue q) {
//        if (traceOn){
//            logger.log (Level.INFO, "Callflow: ConsumerQProcessor.processProducerQ "+
//                    q.getName ());
//        }
//        TransferObject[] to = q.getAndRemoveAll();
//        if (to != null){
//            writeToDb(to, q.getName());
//        }
//    }
    
//    private void writeToDb(TransferObject[] to, String name) {
//        dbAccessObject.insert(to);
//        if (traceOn){            
//            for (int i=0; i<to.length; i++){
//                // just display one
//                logger.log (Level.INFO, "Writing TO to DB :" +name + " "+
//                        to[i].getClass().getName() );
//                break;
//            }
//        }
//    }

    public int getSleepTime() {
        return sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getNumOfQueuesProcessed() {
        return numOfQueuesProcessed;
    }

    public long getNumOfTimesQSlept() {
        return numOfTimesQSlept;
    }

    public String getCONSUMER_SLEEP_TIME() {
        return CONSUMER_SLEEP_TIME;
    }
}
