/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RequestStartAccessObjectImpl.java
 *
 * Created on July 11, 2005, 11:15 AM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import com.sun.enterprise.admin.monitor.callflow.TableInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;
/**
 *
 * @author Harpreet Singh
 */
public class RequestStartAccessObjectImpl extends AbstractTableAccessObject{
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    private static RequestStartAccessObjectImpl _singletonRS;

    /**
     * Creates a new instance of RequestStartAccessObjectImpl 
     */
    private RequestStartAccessObjectImpl() {
        String serverName = super.getServerInstanceName();        
        super.tableName = TableInfo.REQUEST_START_TABLE_NAME + 
                serverName.toUpperCase();
        super.setName ("RequestStart");        
    }

    public String getInsertSQL () {
        String newsql = super.updateSqlWithTableName(
                TableInfo.INSERT_INTO_TABLE_REQUEST_START_SQL, 
                TableInfo.REQUEST_START_TABLE_NAME);
        return newsql;
    }

    public String getDeleteSQL () {
        String newsql = super.updateSqlWithTableName (
                TableInfo.DELETE_FROM_TABLE_REQUEST_START_SQL,
                TableInfo.REQUEST_START_TABLE_NAME);
        return newsql;
    }
    
    public boolean dropTable(Connection connection) {
        super.con = connection;
        return super.createStatmentAndExecuteUpdate(TableInfo.
                DROP_TABLE_REQUEST_START_SQL, TableInfo.REQUEST_START_TABLE_NAME);
                

    }

    public boolean createTable (Connection connection){
        super.con = connection;
        return super.createTable(TableInfo.
                CREATE_TABLE_REQUEST_START_SQL, TableInfo.REQUEST_START_TABLE_NAME);
       
    }
    
    
    public static synchronized TableAccessObject getInstance() {
        if(_singletonRS == null)
            _singletonRS = new RequestStartAccessObjectImpl ();
        
        return _singletonRS;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] requestStart) {
        // sanity
        if (pstmt == null)
            return false;
            
        boolean result = false;
        try{
            for (int i = 0 ; i<requestStart.length; i++) {
                RequestStartTO request = (RequestStartTO)requestStart[i];
                pstmt.setString(1, request.getRequestId());
                pstmt.setLong(2, request.getTimeStamp());
                pstmt.setLong (3, request.getTimeStampMillis());
                if(request.getRequestType() != null)
                    pstmt.setString(4, request.getRequestType().toString());
                else
                    pstmt.setString(4, null);
                if (request.getIpAddress() != null)
                    pstmt.setString(5, request.getIpAddress());
                else 
                    pstmt.setString (5, null);
                
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result =  (updated.length == requestStart.length)? true : false;
            addTotalEntriesProcessed(updated.length);            
            if (isTraceOn()){
                logger.log(Level.INFO, "Callflow: RequestStartAccessObjectImpl " +
                        " Attempting to Insert : " + requestStart.length +
                        " Inserted "+updated.length+ " rows."+
                        " Total Entries written so far:  "+ 
                        getTotalEntriesProcessed());
            }
            
            if (result == false){
                logger.log(Level.WARNING, "callflow.error_insert_row");
            }
        }  catch(BatchUpdateException bue) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }catch (SQLException se) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }
  

}
