/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt;

import java.util.Map;
import java.util.Properties;

/**
 */
public interface InstancesManager
{    
    /**
     * Creates a server instance.
     * @throws InstanceException  This exception is thrown if 
     *  - the instance already exists.
     *  - an invalid or insufficient config. is supplied.
     *  - an exception occurred during instance creation.
     */
    public void createInstance() 
        throws InstanceException;

    /**
     * Deletes an instance identified by the given name.
     * (Should we stop the instance before deleting the instance?)
     * @throws InstanceException  This exception is thrown if 
     * - the instance doesnot exist.
     * - an exception occurred while deleting the instance.
     */
    public void deleteInstance() 
        throws InstanceException;

    /**
     * Starts the instance.
     * @param startParams 
     * @throws InstanceException
     */
    public Process startInstance() 
        throws InstanceException;

    /**
     * Starts the instance.
     * @param interativeOptions which may be used for security, these paramters
     * are passed in on the standard input stream of the executing process
     * @throws InstanceException
     */
    public Process startInstance(String[] interativeOptions) 
        throws InstanceException;

    /**
     * Starts the instance.
     * @param interativeOptions which may be used for security, these paramters
     *        are passed in on the standard input stream of the executing process
     * @param commandLineArgs is additional commandline arguments that are to be appended
     *        to the processes commandline when it starts
     * @throws InstanceException
     */
    public Process startInstance(String[] interativeOptions, String[] commandLineArgs) 
        throws InstanceException;
  
    /**
     * Starts the instance.
     * @param interativeOptions which may be used for security, these paramters
     *        are passed in on the standard input stream of the executing process
     * @param commandLineArgs is additional commandline arguments that are to be appended
     *        to the processes commandline when it starts
     * @param envProps properties to be added to System
     * @throws InstanceException
     */
    public Process startInstance(String[] interativeOptions, String[] commandLineArgs, Properties envProps) 
        throws InstanceException;
    
    /**
     * Stops the instance.
     * @throws InstanceException  
     */    
    public void stopInstance() 
        throws InstanceException;

    /**
     * Lists all the instances.
     */
    public String[] listInstances() 
        throws InstanceException;

    /**
     * Returns status of an instance.
     */
    public int getInstanceStatus()
        throws InstanceException;

    /**
     * @return true if the instance requires a restart for some config changes
     * to take effect, false otherwise.
     */
    boolean isRestartNeeded() throws InstanceException;

    public String getNativeName();
}
