/*
 * DASLauncher.java
 *
 * Created on October 9, 2006, 12:12 PM
 *
 * @author bnevins
 */

package com.sun.enterprise.admin.servermgmt.launch;

import com.sun.enterprise.util.SystemPropertyConstants;
import java.util.*;

public class DASLauncher
{
    public DASLauncher(DASLauncherInfo Info) throws ASLauncherException
    {
        info = Info;
        info.validate();
    }

    ///////////////////////////////////////////////////////////////////////////
    
    public DASLauncher(String... Args) throws ASLauncherException
    {
        info = new DASLauncherInfo(Args);
        info.validate();
    }

    ///////////////////////////////////////////////////////////////////////////
    
    public int launch() throws ASLauncherException
    {
        setArgs();
        info.setSystemProps();
        asLauncher = new ASLauncher();
        asLauncher.process(args);
        return asLauncher.returnValue;
    }

    ///////////////////////////////////////////////////////////////////////////
    
    private void setArgs()
    {
        ArrayList<String> argsList = new ArrayList<String>();
        
        argsList.add("start");

        if(info.verbose)
            argsList.add("verbose");
        
        if(info.debug)
            argsList.add("debug");
        
        args = argsList.toArray(new String[argsList.size()]);
    }

    ///////////////////////////////////////////////////////////////////////////
    
    public static void main(String[] args) 
    {
        try
        {
            DASLauncher dasLauncher = new DASLauncher(args);
            System.exit(dasLauncher.launch());
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }

    ///////////////////////////////////////////////////////////////////////////
    
    private ASLauncher asLauncher;
    private DASLauncherInfo info;
    private String[]        args;
}
