/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: RepositoryNameValidatorTest.java,v 1.3 2005/12/25 03:44:11 tcfujii Exp $
 */

package com.sun.enterprise.admin.servermgmt;

import java.util.Random;

//junit imports
import junit.framework.*;
import junit.textui.TestRunner;

public class RepositoryNameValidatorTest extends TestCase
{
    static final char[] INVALID_CHARS = 
        {'/', '\\', ':', '*', '?', '"', '<', '>', '|', ',', '=', '', ' ', '&', ';', '[', ']', '{', '}', '(', ')', '%', '$', '^', '!'};

    static final char[] VALID_CHARS = {'a', '0', '-', '_', '.'};

    static final int ITERATIONS = 100;

    Validator   validator;
    Random      random;

    public void testNull()
    {
        testInvalid(null);
    }

    public void testZeroLength()
    {
        testInvalid("");
    }

    public void testInvalidChar()
    {
        for (int i = 0; i < INVALID_CHARS.length; i++)
        {
            testInvalid("" + INVALID_CHARS[i]);
        }
    }

    public void testInvalidStr()
    {
        for (int i = 0; i < ITERATIONS; i++)
        {
            testInvalid("" + 
                INVALID_CHARS[random.nextInt(INVALID_CHARS.length)] + 
                INVALID_CHARS[random.nextInt(INVALID_CHARS.length)]);
        }
    }

    public void testValidChar()
    {
        for (int i = 0; i < VALID_CHARS.length; i++)
        {
            testValid("" + VALID_CHARS[i]);
        }
    }

    public void testValidStr()
    {
        for (int i = 0; i < ITERATIONS; i++)
        {
            testValid("" + 
                VALID_CHARS[random.nextInt(VALID_CHARS.length)] + 
                VALID_CHARS[random.nextInt(VALID_CHARS.length)]);
        }
    }

    public void testCombination()
    {
        for (int i = 0; i < ITERATIONS; i++)
        {
            testInvalid("" + 
                VALID_CHARS[random.nextInt(VALID_CHARS.length)] + 
                INVALID_CHARS[random.nextInt(INVALID_CHARS.length)]);
        }
    }

    public RepositoryNameValidatorTest(String name) throws Exception
    {
        super(name);
    }

    protected void setUp()
    {
        validator   = new RepositoryNameValidator("repository name");
        random      = new Random();
    }

    protected void tearDown()
    {
        validator   = null;
        random      = null;
    }

    public static junit.framework.Test suite()
    {
        TestSuite suite = new TestSuite(RepositoryNameValidatorTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception
    {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(
            RepositoryNameValidatorTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }

    void testInvalid(String invalid)
    {
        try
        {
            validator.validate(invalid);
            System.out.println(invalid);
            Assert.assertTrue(false);
        }
        catch (Exception e)
        {
            //ok
        }
    }

    void testValid(String valid)
    {
        try
        {
            validator.validate(valid);
        }
        catch (Exception e)
        {
            Assert.assertTrue(false);
        }
    }
}
