/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * J2EEModuleCallBackImpl.java
 *
 * Created on April 29, 2002, 6:26 PM
 */

package com.sun.enterprise.management.util;

import com.sun.enterprise.management.model.J2EEDeployedObjectMdl;
import com.sun.enterprise.management.util.J2EEModuleCallBack;

import javax.management.MBeanException;

/**
 *
 * @author  prakash
 * @version 
 */
public class J2EEModuleCallBackImpl implements J2EEModuleCallBack {

    private String name;
    private String parentName;
    private String deploymentDescriptor;
    private String serverName;
    private J2EEManagementObjectManager mgmtObjectManager;
    private StartStopCallback sscb;

    public J2EEModuleCallBackImpl(String nm, String pName, String dd,
				J2EEManagementObjectManager mgmtObjectManager) {
        this.name = nm;
        this.parentName = pName;
        this.deploymentDescriptor = dd;
	this.mgmtObjectManager = mgmtObjectManager;
    }

    public J2EEModuleCallBackImpl(String nm, String pName, String serverName, String dd,
                                J2EEManagementObjectManager mgmtObjectManager) {
        this.name = nm;
        this.parentName = pName;
        this.deploymentDescriptor = dd;
        this.serverName = serverName;
        this.mgmtObjectManager = mgmtObjectManager;
    }

    public J2EEModuleCallBackImpl(String nm, String pName, String serverName, String dd,
                                StartStopCallback sscb) {
        this.name = nm;
        this.parentName = pName;
        this.deploymentDescriptor = dd;
        this.serverName = serverName;
        this.sscb = sscb;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    /* Invokes the start method of StartStop callback */
    public void start(Object module) {
        try {
            sscb.startModule((J2EEDeployedObjectMdl)module);
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /* Invokes the stop method of StartStop callback */
    public void stop(Object module) {
        try {
            sscb.stopModule((J2EEDeployedObjectMdl)module);
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    
    public String getName() {
        return this.name;
    }
    
    public String getParentName() {
        return this.parentName;
    }

    public String getServerName() {
        return this.serverName;
    }
    
}
