/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AuthenticationListenerImpl.java
 */

package com.sun.enterprise.admin.wsmgmt.agent;

import java.security.Principal;
import com.sun.enterprise.webservice.monitoring.AuthenticationListener;
import com.sun.enterprise.webservice.monitoring.WebServiceEngine;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineFactory;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigProvider;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigFactory;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.stats.impl.WebServiceEndpointStatsProviderImpl;

import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterRegistry;
import com.sun.enterprise.admin.wsmgmt.msg.MessageFilter;
import com.sun.enterprise.admin.wsmgmt.agent.GlobalMessageListenerImpl;
import com.sun.appserv.management.ext.wsmgmt.MessageTraceImpl;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.List;
import java.util.Iterator;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * This interface allows to register interest in authentication events 
 * in the web service container. 
 *
 * @author Satish Viswanatham 
 */
public class AuthenticationListenerImpl implements AuthenticationListener {
    
    public AuthenticationListenerImpl() {
        try {
            cfgProv = ConfigFactory.getConfigFactory().getConfigProvider();
        } catch (Exception e) {
            _logger.fine("Config provider could not be initialized " +
                e.getMessage());
        }
     }

    /**
     * notification that a user properly authenticated while making 
     * a web service invocation.
     */
    public void authSucess(BundleDescriptor desc, Endpoint ep, Principal principal) {
        // all the data is collected by Message listener for the success case
    }
    
    /**
     * notification that a user authentication attempt has failed.
     * @param endpointSelector the endpoint selector 
     * @param principal Optional principal that failed
     */
    public void authFailure(BundleDescriptor desc, Endpoint ep, Principal principal) {
        if (ep == null) {
            _logger.fine("Endpoint is null for " + desc.getModuleID());
            return;
        }
        // get the endpoint's fully qualified name
        String fqn =WebServiceMgrBackEnd.getManager().getFullyQualifiedName(ep);
        if (fqn == null) {
            _logger.fine("Fully Qualified could not be computed for the selector " +
            ep.getEndpointSelector());
            return;
        }
        WebServiceConfig wsc = cfgProv.getWebServiceConfig(fqn);
        if ((wsc == null) || (wsc.getMonitoringLevel() == null) 
                || (wsc.getMonitoringLevel().equals("OFF"))) {
            // in this case, there wont be any stats 
            _logger.fine("Monitoring is OFF for webservice endpoint " +
                fqn);
            return;
        }
        // get its corresponding stats provider
        WebServiceEndpointStatsProviderImpl impl = (
             WebServiceEndpointStatsProviderImpl) StatsProviderManager.
             getInstance().getEndpointStatsProvider(fqn);
        if (impl == null) {
            if (cfgProv != null) {
                String msg = _stringMgr.getString("Auth.StatsNotReg", fqn);
                throw new RuntimeException(msg);
            }
         return;
        }
        // set auth failure time stamp
        impl.setAuthFailure(System.currentTimeMillis());
        

        /** enable the following code, once bug# 6418025 is fixed.
         ** Need a way to HTTP headers and client host information.
         ** SOAPMessageContext needed to be passed to this method.
         **
        // create empty message trace for this element
        List l =
        FilterRegistry.getInstance().getFilters(Filter.POST_PROCESS_RESPONSE,
                        fqn); 
        Iterator itr = l.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o instanceof MessageFilter) {
                MessageTraceImpl m = new MessageTraceImpl(
                   new Integer(GlobalMessageListenerImpl.newSequenceNumber())
                   .toString());
                m.setRequestSize(0);
                m.setResponseSize(0);
                m.setRequestContent(null);
                m.setResponseContent(null);
                //m.setTransportType();
                //m.setHTTPRequestHeaders();
                //m.setHTTPResponseHeaders();
                //m.setClientHost();
                // Setting principal name to principal.getName() causing issues
                m.setPrincipalName(null);
                m.setResponseTime(0);
                m.setFaultCode("999");
                m.setFaultString(null);
                m.setFaultActor(null);
                m.setTimeStamp(System.currentTimeMillis());
                //m.setCallFlowEnabled(false);
                m.setEndpointName(fqn);
                m.setApplicationID(null);

                ((MessageFilter)o)._handler.addMessage(m);
                return;
            }
        }
        */
    }

    /** PRIVATE VARIABLES */
    private static final Logger _logger =
          Logger.getLogger(LogDomains.ADMIN_LOGGER);
    private ConfigProvider cfgProv = null;
    private static final StringManager _stringMgr =
            StringManager.getManager(AuthenticationListenerImpl.class);
}
