/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.stats.impl;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import com.sun.enterprise.server.ApplicationServer;

import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;

import java.util.logging.Logger;
import com.sun.enterprise.log.Log;
import com.sun.logging.LogDomains;

/**
 * Base class for all the StatsImpl. Also provides a couple
 *  of methods for MonitorListener
 *
 * @author Satish Viswanatham
 */
public abstract class StatsImpl
    implements Stats
{
    protected final static Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);

    private GenericStatsImpl	    genericStatsDelegate;
    protected boolean		    monitorOn = false;
    protected boolean		    registered = true;
    private MonitoringLevel	    currentMonitoringLevel;

    protected StatsImpl() {
    }
    
    protected void initialize(String statInterfaceName) {
	try {
	    genericStatsDelegate =  new GenericStatsImpl(statInterfaceName, this);
	} catch(ClassNotFoundException cnfEx) {
	    throw new RuntimeException(statInterfaceName + " not found", cnfEx);
	}
    }

    public Statistic getStatistic(String statName) {
	return genericStatsDelegate.getStatistic(statName);
    }

    public String[] getStatisticNames() {
	return genericStatsDelegate.getStatisticNames();
    }

    public Statistic[] getStatistics() {
	return genericStatsDelegate.getStatistics();
    }

    public String statToString() {
	StringBuffer sbuf = new StringBuffer();
	Statistic[] stats = getStatistics();
	int sz = stats.length;
	for (int i=0; i<sz; i++) {
	    if (stats[i] instanceof CountStatistic) {
		CountStatistic stat = (CountStatistic) stats[i];
		sbuf.append(stat.getName()).append("=")
		    .append(stat.getCount()).append("; ");
	    } else if (stats[i]  instanceof BoundedRangeStatistic) {
		BoundedRangeStatistic stat = (BoundedRangeStatistic) stats[i];
		sbuf.append(stat.getName()).append("=")
		    .append(stat.getCurrent()).append("; ");
	    } else {
		sbuf.append(stats[i].getName()).append("=?");
	    }
	}

	return sbuf.toString();
    }
}
