/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.addons;

/**
 * Name of an implementation of this interface will be configured in the 
 * META-INF/services/com.sun.appserv.addons.Configurator file. Appserver
 * will instantiate this class and use it for configuring and unconfiguring
 * the addon.
 *
 * @see com.sun.appserv.addons.Installer
 * @author Binod P.G
 * @since 9.1
 */
public interface Configurator {

     /**
      * Performs the configuration of the addon. Typically it involves
      * the creation of instance/domain specific artifacts and configuring
      * the domain.xml, server.policy etc.
      * <p>
      * When ConfigurationContext.ConfigurationType is DAS, the configurator
      * is supposed to make any changes required for the domain. For example,
      * it can insert a lifecycle-module element in the domain.xml with 
      * object-type="system-all", so that the lifecycle module will be 
      * available in all instances created in that domain.
      * <p>
      * The configurator is expected to use the system property called
      * com.sun.aas.AddonRoot for referring to the shared bits of the addon.
      * For example, the location of the system-all lifecycle module may be 
      * specified as ${com.sun.aas.AddonRoot}/<addon-name>/lib/lc-impl.jar
      * <p>
      * When ConfigurationContext.ConfigurationType is INSTANCE, the 
      * configurator is expected to make any changes required for a particular 
      * instance. This may be creating a system-propery to specify a 
      * port number.
      * <p>
      * If this method throw a AddonFatalException or RuntimeException, the 
      * appserver startup will not continue. If it throws AddonException,
      * then the appserver startup will continue after displaying the 
      * error message.
      *
      * @param cc <code>ConfigurationContext</code> object.
      */
     void configure(ConfigurationContext cc) throws AddonException; 

     /**
      * Performs the unconfiguration of the addon. Typically it involves
      * the removal of instance/domain specific artifacts and deleting 
      * the domain.xml entries. For example, all application-refs pointing
      * to the system application or  may be removed by the addon.
      * <p>
      * If this method throw a AddonFatalException or RuntimeException, the 
      * appserver startup will not continue. If it throws AddonException,
      * then the appserver startup will continue after displaying the 
      * error message.
      *
      * @param cc <code>ConfigurationContext</code> object.
      */
     void unconfigure(ConfigurationContext cc) throws AddonException; 

     /**
      * Disable the addon. Typically, addon will modify some configuration
      * (eg: Lifecycle module) to stop it from functioning. If the addon
      * has deployed an application, then the application will be disabled
      * in this step.
      * <p>
      * If this method throw a AddonFatalException or RuntimeException, the 
      * appserver startup will not continue. If it throws AddonException,
      * then the appserver startup will continue after displaying the 
      * error message.
      *
      * @param cc <code>ConfigurationContext</code> object.
      */
     void disable(ConfigurationContext cc) throws AddonException; 

     /**
      * Enable the addon. Typically, addon will modify some configuration
      * (eg: Lifecycle module) to start functioning. If the addon has disabled
      * and application, then addon will re-enable that application in 
      * this step.
      * <p>
      * If this method throw a AddonFatalException or RuntimeException, the 
      * appserver startup will not continue. If it throws AddonException,
      * then the appserver startup will continue after displaying the 
      * error message.
      *
      * @param cc <code>ConfigurationContext</code> object.
      */
     void enable(ConfigurationContext cc) throws AddonException; 


     /**
      * Upgrade the addon. 
      * <p>
      * If this method throws AddonFatalException or RuntimeException, the 
      * appserver startup will not continue. If it throws AddonException,
      * then the appserver startup will continue after displaying the 
      * error message.
      *
      * @param cc <code>ConfigurationContext</code> object.
      * @param version <code>AddonVersion</code> object corresponding to the existing version.
      */
     void upgrade(ConfigurationContext cc, AddonVersion version) throws AddonException; 
}
