/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.addons;

/**
 * <p> Name of an implementation of this interface will be put in the 
 * META-INF/services/com.sun.appserv.addons.Installer file of the addon 
 * installer jar file. 
 * 
 * SDK installer or asadmin install-addon command will instantiate this 
 * class and execute <code>install</code> method. 
 *
 * SDK uninstaller or asadmin uninstall-addon command will instantiate this 
 * class and execute <code>uninstall</code> method. 
 *
 * @see com.sun.appserv.addons.Configurator
 */
public interface Installer {

     /**
      * <p>
      * Installs the Addon on top of the appserver. Typically it 
      * will unbundle the addon installable and setup any installation
      * wide configuration or settings. The shared addon bits will be
      * unbundled into the AS_HOME/addons/<addon-name> directory.
      * <p>
      * The addon installer will also copy a configurator plugin
      * to AS_HOME/lib/addons directory. 
      * <p>
      * The addon installer will also copy any system applications
      * to AS_HOME/lib/install/applications directory. 
      * <p>
      * The <code>Installer</code> will be loaded with an instance of 
      * <code>URLClassLoader</code> and ant jars will be added to it's
      * classpath. 
      * <p>
      * If this method throws an AddonFatalException or RuntimeException
      * Appserver installation will be aborted. However if it throws
      * an AddonException, then the appserver installation will continue 
      * after displaying the error message. 
      *
      * @param ic <code>InstallationContext</code> object.
      */
     void install(InstallationContext ic) throws AddonException; 

     /**
      * <p>
      * Perform uninstallation activity. It rollbacks any change 
      * <code>Installer</code> did during the installation.
      * This include the removal of the system applications from 
      * the lib/install/applications directory also.
      * <p>
      * The <code>Installer</code> will be loaded with an instance of 
      * <code>URLClassLoader</code> and ant jars will be added to it's
      * classpath. 
      * <p>
      * If this method throws an AddonFatalException or RuntimeException
      * Appserver uninstallation will be aborted. However if it throws
      * an AddonException, then the appserver uninstallation will continue 
      * after displaying the error message. 
      *
      * @param ic <code>InstallationContext</code> object.
      */
     void uninstall(InstallationContext ic) throws AddonException; 

     /**
      * Upgrade the addon. 
      * <p>
      * If this method throws AddonFatalException or RuntimeException, the 
      * appserver startup will not continue. If it throws AddonException,
      * then the appserver startup will continue after displaying the 
      * error message.
      *
      * @param ic <code>InstallationContext</code> object.
      * @param version <code>AddonVersion</code> object corresponding to the existing version.
      */
     void upgrade(InstallationContext ic, AddonVersion version) throws AddonException; 
}
