/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.addons.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import com.sun.enterprise.addons.AddonRegistry;

/**
 * A Filenamefilter that return all configurator plugins
 * that require an invocation of configurator api.
 *  
 * @since 9.1 
 * @authod binod@dev.java.net
 */
public class ConfigurableJarFileFilter implements FilenameFilter {
    private Pattern p = null;
    private AddonRegistry ar = null;
    protected static final String regex = "\\.[j|J][a|A][r|R]";
    public ConfigurableJarFileFilter(AddonRegistry ar) {
        p = Pattern.compile(".*" + regex);
        this.ar = ar;
    }

    public boolean accept(File file, String name) {
        return p.matcher(name).matches();
        /*
        the check is done any way before invoking API
        if ( p.matcher(name).matches() ) {
            String addon = name.split(regex)[0];
            return ar.isConfigurationRequired(addon);
        } 
        return false;
        */
    }
}
