/*
 * JAXWSRuntimeEndpointHelper.java
 *
 * Created on February 2, 2006, 3:08 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;


/**
 *
 * @author mu125243
 */
public class JAXRPCRuntimeEndpointHelper {
    
    /** Creates a new instance of JAXWSRuntimeEndpointHelper */
    public JAXRPCRuntimeEndpointHelper() {
    }
    
    public static Object populateRuntimeInfo(ServiceEngineEndpoint endpt)
    throws ServiceEngineException {
        Object runtimeInfo = null;
        if(endpt.isImplementedByEJB()) {
            runtimeInfo = populateEjbRuntimeInfo(endpt);
        } /*else {
            runtimeInfo = populateWebRuntimeInfo(endpt);
        }*/
    
        return runtimeInfo;
    }
    
    private static Object populateEjbRuntimeInfo(
            ServiceEngineEndpoint endpt) throws ServiceEngineException {
        try {
            WebServiceEjbEndpointRegistry registry =
                    WebServiceEjbEndpointRegistry.getRegistry();
            
            EjbRuntimeEndpointInfo ejbRtEndptInfo =
                    registry.getEjbWebServiceEndpoint(endpt.getURI(), "POST", null);
            
            
            return ejbRtEndptInfo;
        } catch(Exception e) {
            throw new ServiceEngineException(e.getMessage());
        }
    }
}
