/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.bridge.transport.JAXRPCClientTransportFactory;
import com.sun.enterprise.jbi.serviceengine.bridge.transport.JBITransportPipe;
import com.sun.enterprise.webservice.ServiceEngineFacade;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.WSBinding;
import javax.xml.namespace.QName;
import java.net.URL;


/**
 *
 * @author Manisha Umbarje
 */
public class ServiceEngineFacadeImpl implements ServiceEngineFacade {
    
    private static ServiceEngineFacadeImpl facade = new ServiceEngineFacadeImpl();
    
    
    /** Creates a new instance of ServiceEngineFacade */
    private ServiceEngineFacadeImpl() {
    }
    
    public static ServiceEngineFacadeImpl getInstance() {
        return facade;
    }
    
    public Object getTransportFactory(ServiceRefPortInfo portInfo,
            boolean oneWay) throws ServiceEngineException {
        
        return new JAXRPCClientTransportFactory(portInfo);
    }
    
    public void handleWebServiceEndpointEvent(String endpointRelativeURI,
            boolean jbiEnabled) throws ServiceEngineException {
        EndpointHelper.getInstance().toggleEndpointStatus(endpointRelativeURI,
                jbiEnabled);
    }
    
    public Pipe createJBITransportPipe(WSBinding binding, 
                                       URL wsdlLocation, 
                                       QName service,
                                       WSDLPort wsdlPort) {
        return new JBITransportPipe(binding, wsdlLocation, service, wsdlPort);
    }

    public boolean hasConsumerEP(QName serviceName, String endpointName) {
        return EndpointRegistry.getInstance().hasConsumerEP(serviceName, endpointName);
    }
}
