/*
 * InOnlyMEPHandler.java
 *
 * Created on November 16, 2006, 12:18 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.NormalizedMessage;

/**
 *
 * This class handles sending message to & receiving message from NMR when
 *
 *  1) Role of the component is Consumer.
 *  2) Message exchange pattern is In-Only.
 *
 * @author bhavanishankar@dev.java.net
 */

public class ConsumerInOnly extends MessageExchangeTransportImpl {
    
    protected InOnly me;
    
    public ConsumerInOnly(InOnly me) {
        super(me);
        this.me = me;
    }
    
    public NormalizedMessage receiveNormalized() {
        return null;
    }
    
    public void send(NormalizedMessage request) {
        try {
            this.msg = request;
            me.setInMessage(request);
            send();
        } catch(Exception ex) {
            sendError(ex);
        }
    }

    // Direct invocation is not implemented in the consumer side.
    public UnWrappedMessage receive(EndpointMetaData emd) {
        return null;
    }
    
    public void send(Message message, EndpointMetaData emd) {
        try {
            WrappedMessage wrappedMessage = new WrappedMessage(message,
                    me.getOperation().getLocalPart(),
                    emd,
                    false
                    );
            NormalizedMessage normalizedMessage = me.createMessage();
            normalizedMessage.setContent(wrappedMessage.readPayloadAsSource());
            send(normalizedMessage);
        } catch(Exception ex) {
            ex.printStackTrace();
        }
    }

}
