/*
 * InOutMEPHandler.java
 *
 * Created on November 16, 2006, 12:16 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import java.util.logging.Level;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.NormalizedMessage;

/**
 *
 * This class handles sending message to & receiving message from NMR when
 *
 *  1) Role of the component is Consumer.
 *  2) Message exchange pattern is In-Out.
 *
 * @author bhavanishankar@dev.java.net
 */

public class ConsumerInOut extends MessageExchangeTransportImpl {
    
    private InOut me;
    
    public ConsumerInOut(InOut me) {
        super(me);
        this.me = me;
    }
    
    public NormalizedMessage receiveNormalized() {
        msg = (me.getFault() != null)? me.getFault() : me.getOutMessage();
        preReceive();
        return msg;
    }
    
    public void send(NormalizedMessage message) {
        try {
            this.msg = message;
            me.setInMessage(message);
            send();
        } catch(Exception ex) {
            // There is no need to send error to NMR in this case.
            ex.printStackTrace();
        }
    }
    
    // Direct invocation is not implemented in the consumer side.
    
    public void send(Message message, EndpointMetaData emd) {
        try {
            WrappedMessage wrappedMessage = new WrappedMessage(message,
                    me.getOperation().getLocalPart(),
                    emd,
                    false
                    );
            NormalizedMessage normalizedMessage = me.createMessage();
            normalizedMessage.setContent(wrappedMessage.readPayloadAsSource());
            send(normalizedMessage);
        } catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public UnWrappedMessage receive(EndpointMetaData emd) {
        NormalizedMessage normalizedMessage = receiveNormalized();
        UnWrappedMessage unwrappedMessage = null;
        if(normalizedMessage != null) {
            try {
                unwrappedMessage = new UnWrappedMessage(
                        normalizedMessage,
                        me.getOperation().getLocalPart(),
                        emd,
                        true
                        );
            } catch(Exception ex) {
                logger.log(Level.INFO, ex.getMessage());
            }
        }
        return unwrappedMessage;
    }
    
}
